/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import java.util.logging.Logger;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.gradle.ArtifactoryGradleConfigurator;
import org.jfrog.hudson.util.ExtractorUtils;

public class BuildUniqueIdentifierHelper {
    private static Logger debuggingLogger = Logger.getLogger(BuildUniqueIdentifierHelper.class.getName());

    private BuildUniqueIdentifierHelper() {
        throw new IllegalAccessError();
    }

    public static AbstractBuild<?, ?> getRootBuild(AbstractBuild<?, ?> currentBuild) {
        AbstractBuild<?, ?> rootBuild = null;
        AbstractBuild<?, ?> parentBuild = BuildUniqueIdentifierHelper.getUpstreamBuild(currentBuild);
        while (parentBuild != null) {
            if (BuildUniqueIdentifierHelper.isPassIdentifiedDownstream(parentBuild)) {
                rootBuild = parentBuild;
            }
            parentBuild = BuildUniqueIdentifierHelper.getUpstreamBuild(parentBuild);
        }
        if (rootBuild == null && BuildUniqueIdentifierHelper.isPassIdentifiedDownstream(currentBuild)) {
            return currentBuild;
        }
        return rootBuild;
    }

    private static AbstractBuild<?, ?> getUpstreamBuild(AbstractBuild<?, ?> build) {
        Cause.UpstreamCause cause = ActionableHelper.getUpstreamCause(build);
        if (cause == null) {
            return null;
        }
        AbstractProject<?, ?> upstreamProject = BuildUniqueIdentifierHelper.getProject(cause.getUpstreamProject());
        if (upstreamProject == null) {
            debuggingLogger.fine("No project found answering for the name: " + cause.getUpstreamProject());
            return null;
        }
        AbstractBuild upstreamBuild = upstreamProject.getBuildByNumber(cause.getUpstreamBuild());
        if (upstreamBuild == null) {
            debuggingLogger.fine("No build with name: " + upstreamProject.getName() + " and number: " + cause.getUpstreamBuild());
        }
        return upstreamBuild;
    }

    private static AbstractProject<?, ?> getProject(String fullName) {
        Item item = Hudson.get().getItemByFullName(fullName);
        if (item != null && item instanceof AbstractProject) {
            return (AbstractProject)item;
        }
        return null;
    }

    public static boolean isPassIdentifiedDownstream(AbstractBuild<?, ?> build) {
        ArtifactoryRedeployPublisher publisher = ActionableHelper.getPublisher(build.getProject(), ArtifactoryRedeployPublisher.class);
        if (publisher != null) {
            return publisher.isPassIdentifiedDownstream();
        }
        ArtifactoryGradleConfigurator wrapper = ActionableHelper.getBuildWrapper((BuildableItem)((BuildableItemWithBuildWrappers)build.getProject()), ArtifactoryGradleConfigurator.class);
        return wrapper != null && wrapper.isPassIdentifiedDownstream();
    }

    public static String getUpstreamIdentifier(AbstractBuild<?, ?> rootBuild) {
        if (rootBuild != null) {
            AbstractProject rootProject = rootBuild.getProject();
            return ExtractorUtils.sanitizeBuildName(rootProject.getFullName()) + "-" + rootBuild.getNumber();
        }
        return null;
    }

    public static String getBuildName(Run build) {
        int stringToBeOmittedIndex;
        String lastItemInBuildName = build.getParent().getName();
        String buildName = build.getParent().getFullName();
        if (!buildName.equals(lastItemInBuildName) && build instanceof MatrixRun && (stringToBeOmittedIndex = buildName.indexOf(lastItemInBuildName)) > 0) {
            buildName = buildName.substring(0, stringToBeOmittedIndex - 1);
        }
        return ExtractorUtils.sanitizeBuildName(buildName);
    }

    public static String getBuildNumber(Run build) {
        String buildNumber = String.valueOf(build.getNumber());
        if (build instanceof MatrixRun) {
            buildNumber = buildNumber + " :: ";
            Combination combination = ((MatrixConfiguration)((MatrixRun)build).getProject()).getCombination();
            buildNumber = buildNumber + combination.toString();
        }
        return buildNumber;
    }

    public static String getBuildNameConsiderOverride(BuildInfoAwareConfigurator configurator, Run build) {
        return configurator.isOverrideBuildName() ? configurator.getCustomBuildName() : BuildUniqueIdentifierHelper.getBuildName(build);
    }
}

