/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.Util;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class FormValidations {
    private static final Pattern VALID_EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z]{2,}){1}$)", 2);

    public static FormValidation validateEmails(String emails) {
        if (emails != null && !emails.isEmpty()) {
            String[] recipients;
            for (String email : recipients = StringUtils.split((String)emails, (String)" ")) {
                FormValidation validation = FormValidations.validateInternetAddress(email);
                if (validation == FormValidation.ok()) continue;
                return validation;
            }
        }
        return FormValidation.ok();
    }

    public static FormValidation validateInternetAddress(String address) {
        if (address == null || address.isEmpty()) {
            return FormValidation.ok();
        }
        Matcher matcher = VALID_EMAIL_PATTERN.matcher(address);
        if (matcher.matches()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Email address is invalid");
    }

    public static FormValidation validateArtifactoryCombinationFilter(String value) throws IOException, InterruptedException {
        String url = Util.fixEmptyAndTrim((String)value);
        if (url == null) {
            return FormValidation.error((String)"Mandatory field - You don`t have any deploy matches");
        }
        return FormValidation.ok();
    }
}

