/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderUtils;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Maven;
import java.io.File;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jfrog.hudson.maven3.MavenVersionCallable;

public class MavenVersionHelper {
    private static final String MINIMUM_MAVEN_VERSION = "3.0.2";

    public static boolean isLowerThanMaven3(MavenModuleSetBuild build, EnvVars vars, BuildListener listener) throws IOException, InterruptedException {
        String version = MavenVersionHelper.getMavenVersion(build, vars, listener);
        if (StringUtils.isBlank((CharSequence)version)) {
            return true;
        }
        ComparableVersion foundVersion = new ComparableVersion(version);
        ComparableVersion neededVersion = new ComparableVersion(MINIMUM_MAVEN_VERSION);
        return foundVersion.compareTo(neededVersion) < 0;
    }

    public static boolean isLowerThanMaven3(MavenModuleSetBuild build) {
        ComparableVersion neededVersion;
        ComparableVersion foundVersion = new ComparableVersion(build.getMavenVersionUsed());
        return foundVersion.compareTo(neededVersion = new ComparableVersion(MINIMUM_MAVEN_VERSION)) < 0;
    }

    public static boolean isAtLeastResolutionCapableVersion(MavenModuleSetBuild build, EnvVars vars, TaskListener listener) throws IOException, InterruptedException {
        return MavenVersionHelper.isAtLeastVersion(build, vars, listener, MINIMUM_MAVEN_VERSION);
    }

    public static boolean isAtLeastVersion(MavenModuleSetBuild build, EnvVars vars, TaskListener listener, String version) throws IOException, InterruptedException {
        Maven.MavenInstallation mavenInstallation = MavenVersionHelper.getMavenInstallation(build, vars, listener);
        return MavenVersionHelper.isAtLeast(build, mavenInstallation.getHome(), version);
    }

    private static Maven.MavenInstallation getMavenInstallation(MavenModuleSetBuild build, EnvVars vars, TaskListener listener) throws IOException, InterruptedException {
        MavenModuleSet project = (MavenModuleSet)build.getProject();
        Maven.MavenInstallation mavenInstallation = project.getMaven();
        if (mavenInstallation == null) {
            throw new AbortException("A Maven installation needs to be available for this project to be built.\nEither your server has no Maven installations defined, or the requested Maven version does not exist.");
        }
        return mavenInstallation.forEnvironment(vars).forNode(build.getBuiltOn().toComputer().getNode(), listener);
    }

    private static boolean isAtLeast(MavenModuleSetBuild build, String mavenHome, String version) throws IOException, InterruptedException {
        return (Boolean)build.getWorkspace().act((Callable)new MavenVersionCallable(mavenHome, version));
    }

    private static String getMavenVersion(MavenModuleSetBuild build, EnvVars vars, BuildListener listener) throws IOException, InterruptedException {
        Maven.MavenInstallation installation = MavenVersionHelper.getMavenInstallation(build, vars, (TaskListener)listener);
        final String home = installation.getHome();
        if (build.getWorkspace() == null) {
            throw new IllegalStateException("build.getWorkspace() is null");
        }
        return (String)build.getWorkspace().act((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                try {
                    return MavenEmbedderUtils.getMavenVersion((File)new File(home)).getVersion();
                }
                catch (MavenEmbedderException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

