/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.hudson.action.ActionableHelper;

public class PluginDependencyHelper {
    public static FilePath getActualDependencyDirectory(File localDependencyFile, FilePath rootPath) throws IOException, InterruptedException {
        FilePath remoteDependencyMark;
        FilePath remoteDependencyDir;
        long currentTime = System.currentTimeMillis();
        File localDependencyDir = localDependencyFile.getParentFile();
        String pluginVersion = Jenkins.get().getPluginManager().getPlugin("artifactory").getVersion();
        boolean isSnapshot = pluginVersion.contains(" ");
        if (isSnapshot) {
            pluginVersion = StringUtils.split((String)pluginVersion, (String)" ")[0];
            pluginVersion = pluginVersion + "-" + currentTime;
        }
        if (!(remoteDependencyDir = new FilePath(rootPath, "cache/artifactory-plugin/" + pluginVersion)).exists()) {
            remoteDependencyDir.mkdirs();
        }
        if (!(remoteDependencyMark = new FilePath(remoteDependencyDir, "done")).exists()) {
            File[] localDependencies;
            for (File localDependency : localDependencies = localDependencyDir.listFiles()) {
                FilePath remoteDependencyFilePath;
                if (localDependency.getName().equals("classes.jar") || (remoteDependencyFilePath = new FilePath(remoteDependencyDir, localDependency.getName())).exists()) continue;
                FilePath localDependencyFilePath = new FilePath(localDependency);
                localDependencyFilePath.copyTo(remoteDependencyFilePath);
            }
            remoteDependencyMark.touch(currentTime);
        }
        if (isSnapshot) {
            ActionableHelper.deleteFilePathOnExit(remoteDependencyDir);
        }
        return remoteDependencyDir;
    }

    public static File getExtractorJar(EnvVars env) throws IOException {
        String libPath = (String)env.get((Object)"ARTIFACTORY_JARS_LIB");
        if (StringUtils.isBlank((CharSequence)libPath)) {
            return Which.jarFile(BuildInfoExtractor.class);
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter("build-info-extractor-*.jar");
        Object[] jars = new File(libPath).listFiles((FileFilter)fileFilter);
        if (ArrayUtils.isEmpty((Object[])jars)) {
            throw new IOException("Artifactory jars lib util doesn't contain the build info extractors");
        }
        return jars[0];
    }

    public static String copyExtractorJars(EnvVars env, FilePath tempDir) throws IOException, InterruptedException {
        File extractorJar = PluginDependencyHelper.getExtractorJar(env);
        FilePath dependencyDir = PluginDependencyHelper.getActualDependencyDirectory(extractorJar, tempDir);
        String absoluteDependencyDirPath = dependencyDir.getRemote();
        return absoluteDependencyDirPath.replace("\\", "/");
    }
}

