/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ProxyUtils;

public abstract class RepositoriesUtils {
    public static List<String> getReleaseRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return new ArrayList<String>();
        }
        return server.getReleaseRepositoryKeysFirst(deployer, null);
    }

    public static List<String> getSnapshotRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return new ArrayList<String>();
        }
        return server.getSnapshotRepositoryKeysFirst(deployer, null);
    }

    public static List<VirtualRepository> getVirtualRepositoryKeys(ResolverOverrider resolverOverrider, DeployerOverrider deployerOverrider, ArtifactoryServer server) {
        if (server == null) {
            return new ArrayList<VirtualRepository>();
        }
        return server.getVirtualRepositoryKeys(resolverOverrider, null);
    }

    public static List<VirtualRepository> generateVirtualRepos(ArtifactoryManager artifactoryManager) throws IOException {
        List keys = artifactoryManager.getVirtualRepositoriesKeys();
        if (keys == null) {
            return new ArrayList<VirtualRepository>();
        }
        List<VirtualRepository> virtualRepositories = keys.stream().map(from -> new VirtualRepository((String)from, (String)from)).collect(Collectors.toList());
        return virtualRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VirtualRepository> getVirtualRepositoryKeys(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(credentialsConfig, artifactoryServer);
        Credentials resolverCredentials = preferredResolver.provideCredentials(item);
        try (ArtifactoryManager artifactoryManager = StringUtils.isNotBlank((CharSequence)resolverCredentials.getUsername()) || StringUtils.isNotBlank((CharSequence)resolverCredentials.getAccessToken()) ? new ArtifactoryManager(url, resolverCredentials.getUsername(), resolverCredentials.getPassword(), resolverCredentials.getAccessToken(), (Log)new NullLog()) : new ArtifactoryManager(url, (Log)new NullLog());){
            List<VirtualRepository> virtualRepositories;
            artifactoryManager.setConnectionTimeout(artifactoryServer.getTimeout());
            RepositoriesUtils.setRetryParams(artifactoryServer, artifactoryManager);
            if (Jenkins.get().proxy != null && !artifactoryServer.isBypassProxy()) {
                artifactoryManager.setProxyConfiguration(ProxyUtils.createProxyConfiguration());
            }
            List<VirtualRepository> list = virtualRepositories = RepositoriesUtils.generateVirtualRepos(artifactoryManager);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLocalRepositories(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(credentialsConfig, artifactoryServer);
        Credentials deployerCredentials = preferredDeployer.provideCredentials(item);
        try (ArtifactoryManager artifactoryManager = StringUtils.isNotBlank((CharSequence)deployerCredentials.getUsername()) || StringUtils.isNotBlank((CharSequence)deployerCredentials.getAccessToken()) ? new ArtifactoryManager(url, deployerCredentials.getUsername(), deployerCredentials.getPassword(), deployerCredentials.getAccessToken(), (Log)new NullLog()) : new ArtifactoryManager(url, (Log)new NullLog());){
            List localRepository;
            artifactoryManager.setConnectionTimeout(artifactoryServer.getTimeout());
            RepositoriesUtils.setRetryParams(artifactoryServer, artifactoryManager);
            if (Jenkins.get().proxy != null && !artifactoryServer.isBypassProxy()) {
                artifactoryManager.setProxyConfiguration(ProxyUtils.createProxyConfiguration());
            }
            List list = localRepository = artifactoryManager.getLocalRepositoriesKeys();
            return list;
        }
    }

    public static ArtifactoryServer getArtifactoryServer(String key) {
        JFrogPlatformInstance JFrogPlatformInstance2 = RepositoriesUtils.getJFrogPlatformInstances(key);
        if (JFrogPlatformInstance2 != null) {
            return JFrogPlatformInstance2.getArtifactory();
        }
        return null;
    }

    public static JFrogPlatformInstance getJFrogPlatformInstances(String key) {
        List<JFrogPlatformInstance> jfrogInstances = RepositoriesUtils.getJFrogPlatformInstances();
        if (jfrogInstances != null && jfrogInstances.size() > 0) {
            for (JFrogPlatformInstance JFrogPlatformInstance2 : jfrogInstances) {
                if (!JFrogPlatformInstance2.getArtifactory().getArtifactoryUrl().equals(key) && !JFrogPlatformInstance2.getArtifactory().getServerId().equals(key)) continue;
                return JFrogPlatformInstance2;
            }
        }
        return null;
    }

    public static List<JFrogPlatformInstance> getJFrogPlatformInstances() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Hudson.get().getDescriptor(ArtifactoryBuilder.class);
        return descriptor.getJfrogInstances();
    }

    public static List<Repository> createRepositoriesList(List<String> repositoriesValueList) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String repositoryKey : repositoriesValueList) {
            Repository repository = new Repository(repositoryKey);
            repositories.add(repository);
        }
        return repositories;
    }

    public static List<VirtualRepository> collectVirtualRepositories(List<VirtualRepository> repositories, String repoKey) {
        if (repositories == null) {
            repositories = new ArrayList<VirtualRepository>();
        }
        if (StringUtils.isNotBlank((CharSequence)repoKey)) {
            for (VirtualRepository vr : repositories) {
                if (!repoKey.equals(vr.getDisplayName())) continue;
                return repositories;
            }
            VirtualRepository vr = new VirtualRepository(repoKey, repoKey);
            repositories.add(vr);
        }
        return repositories;
    }

    public static List<Repository> collectRepositories(String repoKey) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (StringUtils.isNotBlank((CharSequence)repoKey)) {
            Repository r = new Repository(repoKey);
            repositories.add(r);
        }
        return repositories;
    }

    public static void validateServerConfig(AbstractBuild build, BuildListener listener, ArtifactoryServer artifactoryServer, String artifactoryUrl) throws IOException {
        if (artifactoryServer == null) {
            String error = "No Artifactory server configured for " + artifactoryUrl + ". Please check your configuration.";
            listener.getLogger().println(error);
            throw new IOException(error);
        }
    }

    private static void setRetryParams(ArtifactoryServer artifactoryServer, ArtifactoryManager artifactoryManager) {
        RepositoriesUtils.setRetryParams(artifactoryServer.getConnectionRetry(), artifactoryManager);
    }

    public static void setRetryParams(int connectionRetry, ArtifactoryManager artifactoryManager) {
        artifactoryManager.setConnectionRetries(connectionRetry);
    }
}

