/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.util.XStream2;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.util.Credentials;

public class ArtifactoryServerConverter
extends XStream2.PassthruConverter<ArtifactoryServer> {
    Logger logger = Logger.getLogger(ArtifactoryServerConverter.class.getName());
    List<String> converterErrors = new ArrayList<String>();

    public ArtifactoryServerConverter(XStream2 xstream) {
        super(xstream);
    }

    protected void callback(ArtifactoryServer server, UnmarshallingContext context) {
        this.credentialsMigration(server);
        if (!this.converterErrors.isEmpty()) {
            this.logger.info(this.converterErrors.toString());
        }
    }

    private void credentialsMigration(ArtifactoryServer server) {
        try {
            this.deployerMigration(server);
            this.resolverMigration(server);
        }
        catch (NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(server, e));
        }
        catch (IllegalAccessException e) {
            this.converterErrors.add(this.getConversionErrorMessage(server, e));
        }
        catch (IOException e) {
            this.converterErrors.add(this.getConversionErrorMessage(server, e));
        }
    }

    private void deployerMigration(ArtifactoryServer server) throws NoSuchFieldException, IllegalAccessException, IOException {
        Class<?> overriderClass = server.getClass();
        Field deployerCredentialsField = overriderClass.getDeclaredField("deployerCredentials");
        deployerCredentialsField.setAccessible(true);
        Object deployerCredentialsObj = deployerCredentialsField.get(server);
        Field deployerCredentialsConfigField = overriderClass.getDeclaredField("deployerCredentialsConfig");
        deployerCredentialsConfigField.setAccessible(true);
        if (deployerCredentialsObj != null) {
            Credentials deployerCredentials = (Credentials)deployerCredentialsObj;
            deployerCredentialsConfigField.set(server, new CredentialsConfig(deployerCredentials.getUsername(), deployerCredentials.getPassword(), "", true));
        } else if (deployerCredentialsConfigField.get(server) == null) {
            deployerCredentialsConfigField.set(server, CredentialsConfig.EMPTY_CREDENTIALS_CONFIG);
        }
    }

    private void resolverMigration(ArtifactoryServer server) throws NoSuchFieldException, IllegalAccessException, IOException {
        Class<?> overriderClass = server.getClass();
        Field resolverCredentialsField = overriderClass.getDeclaredField("resolverCredentials");
        Field resolverCredentialsConfig = overriderClass.getDeclaredField("resolverCredentialsConfig");
        resolverCredentialsConfig.setAccessible(true);
        resolverCredentialsField.setAccessible(true);
        Object resolverCredentialsObj = resolverCredentialsField.get(server);
        if (resolverCredentialsObj != null) {
            Credentials resolverCredentials = (Credentials)resolverCredentialsObj;
            resolverCredentialsConfig.set(server, new CredentialsConfig(resolverCredentials.getUsername(), resolverCredentials.getPassword(), "", true));
        } else if (resolverCredentialsConfig.get(server) == null) {
            resolverCredentialsConfig.set(server, CredentialsConfig.EMPTY_CREDENTIALS_CONFIG);
        }
    }

    private String getConversionErrorMessage(ArtifactoryServer artifactoryServer, Exception e) {
        return String.format("Could not convert the class '%s' to use the new overridingformat. Cause: %s", artifactoryServer.getClass().getName(), e.getCause());
    }
}

