/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import hudson.util.XStream2;
import java.lang.reflect.Field;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;

public class GenericDeployerResolverOverriderConverter<T>
extends DeployerResolverOverriderConverter<T> {
    public GenericDeployerResolverOverriderConverter(XStream2 xstream) {
        super(xstream);
    }

    @Override
    void overrideResolverDetails(ResolverOverrider overrider, Class<?> overriderClass) {
        try {
            Field oldResolverDetailsField = overriderClass.getDeclaredField("resolverDetails");
            oldResolverDetailsField.setAccessible(true);
            Object oldDeployerDetails = oldResolverDetailsField.get(overrider);
            if (oldDeployerDetails == null) {
                oldResolverDetailsField = overriderClass.getDeclaredField("details");
                oldResolverDetailsField.setAccessible(true);
                oldDeployerDetails = oldResolverDetailsField.get(overrider);
            }
            if (oldDeployerDetails == null || oldResolverDetailsField.get(overrider) == null) {
                return;
            }
            Field specsResolverDetailsField = overriderClass.getDeclaredField("specsResolverDetails");
            Field legacyResolverDetailsField = overriderClass.getDeclaredField("legacyResolverDetails");
            ServerDetails resolverServerDetails = this.createInitialResolveDetailsFromDeployDetails((ServerDetails)oldDeployerDetails);
            this.setServerDetailsIfNew(specsResolverDetailsField, overrider, resolverServerDetails);
            this.setServerDetailsIfNew(legacyResolverDetailsField, overrider, resolverServerDetails);
        }
        catch (ReflectiveOperationException e) {
            this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
        }
    }

    @Override
    void overrideDeployerDetails(DeployerOverrider overrider, Class<?> overriderClass) {
        try {
            Field oldDeployerDetailsField = overriderClass.getDeclaredField("deployerDetails");
            oldDeployerDetailsField.setAccessible(true);
            Object oldDeployerDetails = oldDeployerDetailsField.get(overrider);
            if (oldDeployerDetails == null) {
                oldDeployerDetailsField = overrider.getClass().getDeclaredField("details");
                oldDeployerDetailsField.setAccessible(true);
                oldDeployerDetails = oldDeployerDetailsField.get(overrider);
            }
            if (oldDeployerDetails == null || oldDeployerDetailsField.get(overrider) == null) {
                return;
            }
            Field specsDeployerDetailsField = overriderClass.getDeclaredField("specsDeployerDetails");
            Field legacyDeployerDetailsField = overriderClass.getDeclaredField("legacyDeployerDetails");
            ServerDetails deployerServerDetails = this.createInitialDeployDetailsFromOldDeployDetails((ServerDetails)oldDeployerDetails);
            this.setServerDetailsIfNew(specsDeployerDetailsField, overrider, deployerServerDetails);
            this.setServerDetailsIfNew(legacyDeployerDetailsField, overrider, deployerServerDetails);
        }
        catch (ReflectiveOperationException e) {
            this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
        }
    }

    private void setServerDetailsIfNew(Field serverDetailsField, Object overrider, Object serverDetails) throws IllegalAccessException {
        serverDetailsField.setAccessible(true);
        if (serverDetailsField.get(overrider) == null) {
            serverDetailsField.set(overrider, serverDetails);
        }
    }
}

