/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.plugins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.util.Credentials;

public class PluginsUtils {
    public static final String MULTIJOB_PLUGIN_ID = "jenkins-multijob-plugin";
    public static final String GIT_PLUGIN_ID = "git";
    public static final String PROMOTION_BUILD_PLUGIN_CLASS = "PromotionProcess";
    public static final String JIRA_REST_SERVERINFO_ENDPOINT = "rest/api/2/serverInfo";
    private static ObjectMapper mapper;

    public static ListBoxModel fillPluginCredentials(Item project) {
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        return PluginsUtils.fillPluginCredentials(project, ACL.SYSTEM);
    }

    public static ListBoxModel fillPluginCredentials(Item project, Authentication authentication) {
        List domainRequirements = Collections.emptyList();
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(authentication, project, StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)}));
    }

    public static Credentials usernamePasswordCredentialsLookup(String credentialsId, Item item) {
        UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (usernamePasswordCredentials != null) {
            return new Credentials(usernamePasswordCredentials.getUsername(), usernamePasswordCredentials.getPassword().getPlainText());
        }
        return Credentials.EMPTY_CREDENTIALS;
    }

    public static StringCredentials accessTokenCredentialsLookup(String credentialsId, Item item) {
        StringCredentials accessTokenPasswordCredentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        return accessTokenPasswordCredentials;
    }

    public static boolean isUseCredentialsPlugin() {
        return PluginsUtils.getDescriptor().getUseCredentialsPlugin();
    }

    private static ArtifactoryBuilder.DescriptorImpl getDescriptor() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Hudson.get().getDescriptor(ArtifactoryBuilder.class);
        if (descriptor != null) {
            return descriptor;
        }
        throw new IllegalStateException("ArtifactoryBuilder descriptor is null");
    }

    public static boolean isCredentialsPluginEnabled() {
        return PluginsUtils.getDescriptor().getUseCredentialsPlugin();
    }

    public static String getJiraVersion(URL jiraBaseUrl) {
        HttpResponse response = null;
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            URL requestUrl = new URL(jiraBaseUrl + JIRA_REST_SERVERINFO_ENDPOINT);
            response = client.execute((HttpUriRequest)new HttpGet(requestUrl.toURI()));
            PluginsUtils.lazyInitMapper();
            Map responseMap = (Map)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String string = (String)responseMap.get("version");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to get Jira Issue Tracker version: " + e.getMessage());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private static ObjectMapper lazyInitMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }
}

