/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.action;

import com.jenkinsci.plugins.badge.BadgePlugin;
import com.jenkinsci.plugins.badge.action.AbstractBadgeAction;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import java.io.File;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class BadgeAction
extends AbstractBadgeAction {
    private static final long serialVersionUID = 1L;
    private final String iconPath;
    private final String text;
    private String color = "#000000";
    private String background = "#FFFF00";
    private String border = "1px";
    private String borderColor = "#C0C000";
    private String link;

    private BadgeAction(String iconPath, String text) {
        this.iconPath = iconPath;
        this.text = text;
    }

    public static BadgeAction createBadge(String icon, String text) {
        return new BadgeAction(BadgeAction.getIconPath(icon), text);
    }

    public static BadgeAction createBadge(String icon, String text, String link) {
        BadgeAction action = new BadgeAction(BadgeAction.getIconPath(icon), text);
        action.link = link;
        return action;
    }

    public static BadgeAction createShortText(String text) {
        return new BadgeAction(null, text);
    }

    public static BadgeAction createShortText(String text, String color, String background, String border, String borderColor) {
        return BadgeAction.createShortText(text, color, background, border, borderColor, null);
    }

    public static BadgeAction createShortText(String text, String color, String background, String border, String borderColor, String link) {
        BadgeAction action = new BadgeAction(null, text);
        action.color = color;
        action.background = background;
        action.border = border;
        action.borderColor = borderColor;
        action.link = link;
        return action;
    }

    public static BadgeAction createInfoBadge(String text) {
        return new BadgeAction(BadgeAction.getIconPath("info.gif"), text);
    }

    public static BadgeAction createWarningBadge(String text) {
        return new BadgeAction(BadgeAction.getIconPath("warning.gif"), text);
    }

    public static BadgeAction createErrorBadge(String text) {
        return new BadgeAction(BadgeAction.getIconPath("error.gif"), text);
    }

    public String getUrlName() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getIconFileName() {
        return null;
    }

    @Exported
    public boolean isTextOnly() {
        return this.iconPath == null;
    }

    @Exported
    public String getIconPath() {
        return this.iconPath;
    }

    @Exported
    public String getText() {
        return this.text;
    }

    @Exported
    public String getColor() {
        return this.color;
    }

    @Exported
    public String getBackground() {
        return this.background;
    }

    @Exported
    public String getBorder() {
        return this.border;
    }

    @Exported
    public String getBorderColor() {
        return this.borderColor;
    }

    @Exported
    public String getLink() {
        return this.link;
    }

    public static String getIconPath(String icon) {
        if (icon == null) {
            return null;
        }
        if (icon.startsWith("/")) {
            return icon;
        }
        Jenkins jenkins = Jenkins.getInstance();
        PluginWrapper wrapper = jenkins.getPluginManager().getPlugin(BadgePlugin.class);
        boolean pluginIconExists = wrapper != null && new File(wrapper.baseResourceURL.getPath() + "/images/" + icon).exists();
        return pluginIconExists ? "/plugin/" + wrapper.getShortName() + "/images/" + icon : Hudson.RESOURCE_PATH + "/images/16x16/" + icon;
    }
}

