/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.action;

import com.jenkinsci.plugins.badge.action.AbstractAction;
import hudson.markup.RawHtmlMarkupFormatter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class BadgeSummaryAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BadgeSummaryAction.class.getName());
    private final String iconPath;
    private String summaryText = "";

    public BadgeSummaryAction(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getUrlName() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getIconFileName() {
        return null;
    }

    @Exported
    public String getIconPath() {
        return this.iconPath;
    }

    public String getRawText() {
        return this.summaryText;
    }

    @Exported
    public String getText() {
        try {
            return new RawHtmlMarkupFormatter(false).translate(this.summaryText);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error preparing summary text for ui", e);
            return "<b><font color=\"red\">ERROR</font></b>";
        }
    }

    @Whitelisted
    public void appendText(String text) {
        this.appendText(text, false);
    }

    @Whitelisted
    public void appendText(String text, boolean escapeHtml) {
        if (escapeHtml) {
            text = StringEscapeUtils.escapeHtml((String)text);
        }
        this.summaryText = this.summaryText + text;
    }

    @Whitelisted
    public void appendText(String text, boolean escapeHtml, boolean bold, boolean italic, String color) {
        if (bold) {
            this.summaryText = this.summaryText + "<b>";
        }
        if (italic) {
            this.summaryText = this.summaryText + "<i>";
        }
        if (color != null) {
            this.summaryText = this.summaryText + "<font color=\"" + color + "\">";
        }
        if (escapeHtml) {
            text = StringEscapeUtils.escapeHtml((String)text);
        }
        this.summaryText = this.summaryText + text;
        if (color != null) {
            this.summaryText = this.summaryText + "</font>";
        }
        if (italic) {
            this.summaryText = this.summaryText + "</i>";
        }
        if (bold) {
            this.summaryText = this.summaryText + "</b>";
        }
    }
}

