/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.dsl;

import com.jenkinsci.plugins.badge.action.BadgeAction;
import com.jenkinsci.plugins.badge.annotations.OptionalParam;
import com.jenkinsci.plugins.badge.annotations.Param;
import com.jenkinsci.plugins.badge.dsl.AbstractStep;
import com.jenkinsci.plugins.badge.dsl.AbstractTaskListenerDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AddBadgeStep
extends AbstractStep {
    private final Badge badge;

    @DataBoundConstructor
    public AddBadgeStep(@Param(name="icon", description="The icon for this badge") String icon, @Param(name="text", description="The text for this badge") String text) {
        this.badge = new Badge(icon, text);
    }

    public String getIcon() {
        return this.badge.getIcon();
    }

    public String getText() {
        return this.badge.getText();
    }

    public String getLink() {
        return this.badge.getLink();
    }

    @DataBoundSetter
    @OptionalParam(description="The link to be added to this badge")
    public void setLink(String link) {
        this.badge.setLink(link);
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.badge, this.getId(), context);
    }

    protected Badge getBadge() {
        return this.badge;
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient Badge badge;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String id;
        private static final long serialVersionUID = 1L;

        Execution(Badge badge, String id, StepContext context) {
            super(context);
            this.badge = badge;
            this.id = id;
        }

        protected Void run() throws Exception {
            BadgeAction action = this.newBatchAction(this.badge);
            action.setId(this.id);
            ((Run)this.getContext().get(Run.class)).addAction((Action)action);
            return null;
        }

        protected BadgeAction newBatchAction(Badge badge) {
            return BadgeAction.createBadge(badge.getIcon(), badge.getText(), badge.getLink());
        }
    }

    protected static class Badge
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String icon;
        private final String text;
        private String link;

        private Badge(String icon, String text) {
            this.icon = icon;
            this.text = text;
        }

        protected String getIcon() {
            return this.icon;
        }

        protected String getText() {
            return this.text;
        }

        protected String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractTaskListenerDescriptor {
        public String getFunctionName() {
            return "addBadge";
        }

        public String getDisplayName() {
            return "Add Badge";
        }
    }
}

