/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.dsl;

import com.jenkinsci.plugins.badge.action.HtmlBadgeAction;
import com.jenkinsci.plugins.badge.annotations.Param;
import com.jenkinsci.plugins.badge.dsl.AbstractStep;
import com.jenkinsci.plugins.badge.dsl.AbstractTaskListenerDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddHtmlBadgeStep
extends AbstractStep {
    private final String html;

    @DataBoundConstructor
    public AddHtmlBadgeStep(@Param(name="html", description="The html content to be used for this badge") String html) {
        this.html = html;
    }

    public String getHtml() {
        return this.html;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.html, this.getId(), context);
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String html;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String id;
        private static final long serialVersionUID = 1L;

        Execution(String html, String id, StepContext context) {
            super(context);
            this.html = html;
            this.id = id;
        }

        protected Void run() throws Exception {
            HtmlBadgeAction htmlBadge = HtmlBadgeAction.createHtmlBadge(this.html);
            htmlBadge.setId(this.id);
            ((Run)this.getContext().get(Run.class)).addAction((Action)htmlBadge);
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractTaskListenerDescriptor {
        public String getFunctionName() {
            return "addHtmlBadge";
        }

        public String getDisplayName() {
            return "Add a html badge Text";
        }
    }
}

