/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.dsl;

import com.jenkinsci.plugins.badge.action.BadgeSummaryAction;
import com.jenkinsci.plugins.badge.annotations.OptionalParam;
import com.jenkinsci.plugins.badge.annotations.Param;
import com.jenkinsci.plugins.badge.dsl.AbstractStep;
import com.jenkinsci.plugins.badge.dsl.AbstractTaskListenerDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CreateSummaryStep
extends AbstractStep {
    private final String icon;
    private String text;

    @DataBoundConstructor
    public CreateSummaryStep(@Param(name="icon", description="The icon for this summary") String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    @OptionalParam(description="The title text for this summary")
    public void setText(String text) {
        this.text = text;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.icon, this.text, this.getId(), context);
    }

    public static class Execution
    extends SynchronousStepExecution<BadgeSummaryAction> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String icon;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String text;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final String id;
        private static final long serialVersionUID = 1L;

        Execution(String icon, String text, String id, StepContext context) {
            super(context);
            this.icon = icon;
            this.text = text;
            this.id = id;
        }

        protected BadgeSummaryAction run() throws Exception {
            BadgeSummaryAction action = new BadgeSummaryAction(this.icon);
            if (StringUtils.isNotBlank((String)this.text)) {
                action.appendText(this.text);
            }
            action.setId(this.id);
            ((Run)this.getContext().get(Run.class)).addAction((Action)action);
            return action;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractTaskListenerDescriptor {
        public String getFunctionName() {
            return "createSummary";
        }

        public String getDisplayName() {
            return "Print Message";
        }
    }
}

