// CHECKSTYLE:OFF

package io.jenkins.blueocean.autofavorite;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code autofavorite.name}: {@code Automatically favorite
     * pipelines}.
     * 
     * @return
     *     {@code Automatically favorite pipelines}
     */
    public static String autofavorite_name() {
        return holder.format("autofavorite.name");
    }

    /**
     * Key {@code autofavorite.name}: {@code Automatically favorite
     * pipelines}.
     * 
     * @return
     *     {@code Automatically favorite pipelines}
     */
    public static Localizable _autofavorite_name() {
        return new Localizable(holder, "autofavorite.name");
    }

}
