/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.autofavorite;

import com.google.common.collect.Iterables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.SCMListener;
import hudson.plugins.favorite.Favorites;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.LogTaskListener;
import io.jenkins.blueocean.autofavorite.user.FavoritingUserProperty;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.branch.MultiBranchProject;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.errors.MissingObjectException;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class FavoritingScmListener
extends SCMListener {
    private static final Logger LOGGER = Logger.getLogger(FavoritingScmListener.class.getName());
    static final String BLUEOCEAN_FEATURE_AUTOFAVORITE_ENABLED_PROPERTY = "BLUEOCEAN_FEATURE_AUTOFAVORITE_ENABLED";

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) throws Exception {
        GitChangeSet first;
        if (!FavoritingScmListener.isEnabled()) {
            return;
        }
        if (!(build instanceof WorkflowRun && ((WorkflowJob)((WorkflowRun)build).getParent()).getParent() instanceof MultiBranchProject && build.getNumber() == 1 && scm instanceof GitSCM)) {
            return;
        }
        if (!workspace.exists() || !workspace.isDirectory()) {
            LOGGER.fine("Workspace '" + workspace.getRemote() + "' does not exist or is a directory. Favoriting cannot be run.");
            return;
        }
        BuildData buildData = (BuildData)build.getAction(BuildData.class);
        if (buildData == null) {
            LOGGER.fine("No Git Build Data is present. Favoriting cannot be run.");
            return;
        }
        Revision lastBuiltRevision = buildData.getLastBuiltRevision();
        if (lastBuiltRevision == null) {
            return;
        }
        GitSCM gitSCM = (GitSCM)scm;
        try {
            first = this.getChangeSet(gitSCM, workspace, lastBuiltRevision, listener);
        }
        catch (GitException e) {
            if (e.getCause() instanceof MissingObjectException) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                try {
                    first = this.getChangeSet(gitSCM, workspace, lastBuiltRevision, listener);
                }
                catch (GitException ex) {
                    LOGGER.log(Level.SEVERE, "Git repository is not consistent. Can't get the changeset that was just checked out.", ex);
                    first = null;
                }
            }
            LOGGER.log(Level.WARNING, "Unexpected error when retrieving changeset", e);
            first = null;
        }
        if (first == null) {
            return;
        }
        Job job = build.getParent();
        User author = first.getAuthor();
        if (User.getById((String)author.getId(), (boolean)false) == null || User.getUnknown().equals(author)) {
            return;
        }
        if (!FavoritingUserProperty.from(author).isAutofavoriteEnabled()) {
            return;
        }
        if (Favorites.hasFavorite((User)author, (Item)job) && !Favorites.isFavorite((User)author, (Item)job)) {
            return;
        }
        if (Favorites.isFavorite((User)author, (Item)job)) {
            return;
        }
        try {
            Favorites.addFavorite((User)author, (Item)job);
            LOGGER.log(Level.INFO, "Automatically favorited " + job.getFullName() + " for " + author);
        }
        catch (Favorites.FavoriteException e) {
            LOGGER.log(Level.SEVERE, "Couldn't favourite " + job.getFullName() + " for " + author, e);
        }
    }

    private GitChangeSet getChangeSet(GitSCM scm, FilePath workspace, Revision lastBuiltRevision, TaskListener listener) throws IOException, InterruptedException {
        List changeSets;
        Git gitBuilder = Git.with((TaskListener)listener, (EnvVars)new EnvVars()).in(workspace);
        GitTool tool = scm.resolveGitTool((TaskListener)new LogTaskListener(LOGGER, Level.FINE));
        if (tool != null) {
            LOGGER.log(Level.FINE, "Using Git executable for autofavorite");
            gitBuilder = gitBuilder.using(tool.getGitExe());
        } else {
            LOGGER.log(Level.INFO, "Using JGit for autofavorite. This is less reliable than using the Git executable. You should define a Git tool, see https://jenkins.io/doc/book/managing/tools/");
        }
        GitClient git = gitBuilder.getClient();
        try (StringWriter writer = new StringWriter();){
            git.changelog().includes(lastBuiltRevision.getSha1()).to((Writer)writer).max(1).execute();
            GitChangeLogParser parser = new GitChangeLogParser(true);
            try (StringReader input = new StringReader(writer.toString());){
                List lines = IOUtils.readLines((Reader)input);
                changeSets = parser.parse(lines);
            }
        }
        return (GitChangeSet)Iterables.getOnlyElement((Iterable)changeSets, null);
    }

    static boolean isEnabled() {
        String value = System.getProperty(BLUEOCEAN_FEATURE_AUTOFAVORITE_ENABLED_PROPERTY);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }
}

