/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.autofavorite.user;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import io.jenkins.blueocean.autofavorite.Messages;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class FavoritingUserProperty
extends UserProperty {
    private Boolean autofavoriteEnabled;

    @DataBoundConstructor
    public FavoritingUserProperty(Boolean autofavoriteEnabled) {
        this.autofavoriteEnabled = autofavoriteEnabled;
    }

    public boolean isAutofavoriteEnabled() {
        return this.autofavoriteEnabled;
    }

    @VisibleForTesting
    public void setAutofavoriteEnabled(boolean autofavoriteEnabled) {
        this.autofavoriteEnabled = autofavoriteEnabled;
    }

    public static FavoritingUserProperty from(User user) {
        return (FavoritingUserProperty)user.getProperty(FavoritingUserProperty.class);
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public DescriptorImpl() {
            super(FavoritingUserProperty.class);
        }

        public UserProperty newInstance(User user) {
            return new FavoritingUserProperty(true);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.autofavorite_name();
        }
    }
}

