/*
 * Decompiled with CFR 0.152.
 */
package jenkins.bouncycastle.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.encoders.Base64;

public final class PEMEncodable {
    @Nonnull
    private Object object;
    private static final Logger LOGGER = Logger.getLogger(PEMEncodable.class.getName());

    private PEMEncodable(@Nonnull Object pemObject) {
        this.object = pemObject;
    }

    @Nonnull
    public static PEMEncodable create(@Nonnull Key key) {
        return new PEMEncodable(key);
    }

    @Nonnull
    public static PEMEncodable create(@Nonnull KeyPair keyPair) {
        return new PEMEncodable(keyPair);
    }

    @Nonnull
    public static PEMEncodable create(@Nonnull Certificate certificate) {
        return new PEMEncodable(certificate);
    }

    @Nonnull
    public static PEMEncodable decode(@Nonnull String pem) throws IOException, UnrecoverableKeyException {
        return PEMEncodable.decode(pem, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static PEMEncodable decode(@Nonnull String pem, @Nullable char[] passphrase) throws IOException, UnrecoverableKeyException {
        try (PEMParser parser = new PEMParser((Reader)new StringReader(pem));){
            Object object = parser.readObject();
            if (object == null) {
                throw new IOException("Could not parse PEM, only key pairs, private keys, public keys and certificates are supported");
            }
            JcaPEMKeyConverter kConv = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                if (passphrase == null) throw new UnrecoverableKeyException();
                PEMDecryptorProvider dp = new JcePEMDecryptorProviderBuilder().build(passphrase);
                PEMEncryptedKeyPair ekp = (PEMEncryptedKeyPair)object;
                PEMEncodable pEMEncodable = new PEMEncodable(kConv.getKeyPair(ekp.decryptKeyPair(dp)));
                return pEMEncodable;
            }
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                if (passphrase == null) throw new UnrecoverableKeyException();
                InputDecryptorProvider dp = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase);
                PKCS8EncryptedPrivateKeyInfo epk = (PKCS8EncryptedPrivateKeyInfo)object;
                PEMEncodable pEMEncodable = new PEMEncodable(kConv.getPrivateKey(epk.decryptPrivateKeyInfo(dp)));
                return pEMEncodable;
            }
            if (object instanceof PEMKeyPair) {
                PEMEncodable dp = new PEMEncodable(kConv.getKeyPair((PEMKeyPair)object));
                return dp;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKey pk = kConv.getPrivateKey((PrivateKeyInfo)object);
                if (pk instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rsaPK = (RSAPrivateCrtKey)pk;
                    RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(rsaPK.getModulus(), rsaPK.getPublicExponent());
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    PEMEncodable pEMEncodable = new PEMEncodable(new KeyPair(kf.generatePublic(pubKeySpec), rsaPK));
                    return pEMEncodable;
                }
                PEMEncodable pEMEncodable = new PEMEncodable(pk);
                return pEMEncodable;
            }
            if (object instanceof SubjectPublicKeyInfo) {
                PEMEncodable pk = new PEMEncodable(kConv.getPublicKey((SubjectPublicKeyInfo)object));
                return pk;
            }
            if (object instanceof X509CertificateHolder) {
                JcaX509CertificateConverter cConv = new JcaX509CertificateConverter().setProvider("BC");
                PEMEncodable pEMEncodable = new PEMEncodable(cConv.getCertificate((X509CertificateHolder)object));
                return pEMEncodable;
            }
            throw new IOException("Could not parse PEM, only key pairs, private keys, public keys and certificates are supported. Received " + object.getClass().getName());
        }
        catch (OperatorCreationException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (InvalidKeySpecException | PKCSException e) {
            LOGGER.log(Level.WARNING, "Could not read PEM encrypted information", e);
            throw new UnrecoverableKeyException();
        }
        catch (CertificateException e) {
            throw new IOException("Could not read certificate", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"RSA algorithm support is mandated by Java Language Specification. See https://docs.oracle.com/javase/7/docs/api/java/security/KeyFactory.html");
        }
    }

    @Nonnull
    public String encode() throws IOException {
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter w = new JcaPEMWriter((Writer)sw);){
            w.writeObject(this.object);
        }
        return sw.toString();
    }

    @Nonnull
    public static PEMEncodable read(@Nonnull File pemFile) throws IOException, UnrecoverableKeyException {
        return PEMEncodable.read(pemFile, null);
    }

    @Nonnull
    public static PEMEncodable read(@Nonnull File pemFile, @Nullable char[] passphrase) throws IOException, UnrecoverableKeyException {
        return PEMEncodable.decode(FileUtils.readFileToString((File)pemFile), passphrase);
    }

    public void write(@Nonnull File pemFile) throws IOException {
        FileUtils.writeStringToFile((File)pemFile, (String)this.encode());
    }

    @CheckForNull
    public KeyPair toKeyPair() {
        if (this.object instanceof KeyPair) {
            return (KeyPair)this.object;
        }
        return null;
    }

    @CheckForNull
    public PublicKey toPublicKey() {
        if (this.object instanceof PublicKey) {
            return (PublicKey)this.object;
        }
        if (this.object instanceof KeyPair) {
            return ((KeyPair)this.object).getPublic();
        }
        if (this.object instanceof Certificate) {
            return ((Certificate)this.object).getPublicKey();
        }
        return null;
    }

    @CheckForNull
    public Certificate toCertificate() {
        if (this.object instanceof Certificate) {
            return (Certificate)this.object;
        }
        return null;
    }

    @CheckForNull
    public PrivateKey toPrivateKey() {
        if (this.object instanceof PrivateKey) {
            return (PrivateKey)this.object;
        }
        if (this.object instanceof KeyPair) {
            return ((KeyPair)this.object).getPrivate();
        }
        return null;
    }

    @CheckForNull
    public Object getRawObject() {
        return this.object;
    }

    @CheckForNull
    public String getPrivateKeyFingerprint() {
        PrivateKey key = this.toPrivateKey();
        if (key == null) {
            return null;
        }
        return PEMEncodable.hexEncode(PEMEncodable.getKeyDigestSHA1(key));
    }

    @CheckForNull
    public String getPublicKeyFingerprint() {
        PublicKey key = this.toPublicKey();
        if (key == null) {
            return null;
        }
        return PEMEncodable.hexEncode(PEMEncodable.getKeyDigestMD5(key));
    }

    @Nonnull
    public static byte[] getKeyDigestSHA1(@Nonnull Key k) {
        try {
            return PEMEncodable.getKeyDigest(k, "SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"SHA1 algorithm support is mandated by Java Language Specification. See https://docs.oracle.com/javase/7/docs/api/java/security/MessageDigest.html");
        }
    }

    @Nonnull
    public static byte[] getKeyDigestMD5(@Nonnull Key k) {
        try {
            return PEMEncodable.getKeyDigest(k, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"MD5 algorithm support is mandated by Java Language Specification. See https://docs.oracle.com/javase/7/docs/api/java/security/MessageDigest.html");
        }
    }

    @Nonnull
    public static byte[] getKeyDigest(@Nonnull Key k, @Nonnull String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(k.getEncoded());
        return md.digest();
    }

    @Nonnull
    private static String hexEncode(@Nonnull byte[] data) {
        char[] hex = Hex.encodeHex((byte[])data);
        StringBuilder buf = new StringBuilder(hex.length + Math.max(0, hex.length / 2 - 1));
        for (int i = 0; i < hex.length; i += 2) {
            if (i > 0) {
                buf.append(':');
            }
            buf.append(hex, i, 2);
        }
        return buf.toString();
    }

    @Nonnull
    private static String encodeBase64(@Nonnull byte[] data) {
        return new String(Base64.encode((byte[])data), StandardCharsets.UTF_8);
    }

    @Nonnull
    private static byte[] decodeBase64(@Nonnull String data) {
        return Base64.decode((String)data);
    }
}

