/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

public final class NameEncoder {
    private NameEncoder() {
        throw new IllegalAccessError("Utility class");
    }

    public static String encode(String name) {
        if ("".equals(name)) {
            return "%00";
        }
        if (".".equals(name)) {
            return "%2E";
        }
        if ("..".equals(name)) {
            return "%2E.";
        }
        StringBuilder buf = new StringBuilder(name.length() + 16);
        block9: for (char c : name.toCharArray()) {
            switch (c) {
                case '#': {
                    buf.append("%23");
                    continue block9;
                }
                case '%': {
                    buf.append("%25");
                    continue block9;
                }
                case '/': {
                    buf.append("%2F");
                    continue block9;
                }
                case '?': {
                    buf.append("%3F");
                    continue block9;
                }
                case '[': {
                    buf.append("%5B");
                    continue block9;
                }
                case ']': {
                    buf.append("%5D");
                    continue block9;
                }
                case '\\': {
                    buf.append("%5C");
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String decode(String name) {
        if (name.indexOf(37) == -1) {
            return name;
        }
        if ("%00".equals(name)) {
            return "";
        }
        if ("%2E".equals(name)) {
            return ".";
        }
        if ("%2E.".equals(name)) {
            return "..";
        }
        StringBuilder buf = new StringBuilder(name.length() + 16);
        int matchIndex = 0;
        char match = '\u0000';
        block27: for (char c : name.toCharArray()) {
            switch (matchIndex) {
                case 1: {
                    if (c == '2' || c == '3' || c == '5') {
                        match = c;
                        matchIndex = 2;
                        break;
                    }
                    buf.append('%');
                    buf.append(c);
                    matchIndex = 0;
                    break;
                }
                case 2: {
                    block4 : switch (match) {
                        case '2': {
                            switch (c) {
                                case '3': {
                                    buf.append('#');
                                    break block4;
                                }
                                case '5': {
                                    buf.append('%');
                                    break block4;
                                }
                                case 'F': {
                                    buf.append('/');
                                    break block4;
                                }
                            }
                            buf.append('%');
                            buf.append(match);
                            buf.append(c);
                            break;
                        }
                        case '3': {
                            if (c == 'F') {
                                buf.append('?');
                                break;
                            }
                            buf.append('%');
                            buf.append(match);
                            buf.append(c);
                            break;
                        }
                        case '5': {
                            switch (c) {
                                case 'B': {
                                    buf.append('[');
                                    break block4;
                                }
                                case 'C': {
                                    buf.append('\\');
                                    break block4;
                                }
                                case 'D': {
                                    buf.append(']');
                                    break block4;
                                }
                            }
                            buf.append('%');
                            buf.append(match);
                            buf.append(c);
                            break;
                        }
                        default: {
                            buf.append('%');
                            buf.append(match);
                            buf.append(c);
                        }
                    }
                    matchIndex = 0;
                    break;
                }
                default: {
                    if (c == '%') {
                        matchIndex = 1;
                        break;
                    }
                    matchIndex = 0;
                    buf.append(c);
                }
            }
            switch (c) {
                case '/': {
                    buf.append("%2F");
                    continue block27;
                }
                case '?': {
                    buf.append("%3F");
                    continue block27;
                }
                case '#': {
                    buf.append("%23");
                    continue block27;
                }
                case '[': {
                    buf.append("%5B");
                    continue block27;
                }
                case ']': {
                    buf.append("%5D");
                    continue block27;
                }
                case '\\': {
                    buf.append("%5C");
                    continue block27;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

