/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;

@Extension
public class BranchNameContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Job j, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory projectFactory;
        ItemGroup parent = j.getParent();
        if (parent instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)j)) {
            Branch branch = projectFactory.getBranch(j);
            SCMHead head = branch.getHead();
            envs.put("BRANCH_NAME", head.getName());
            if (head instanceof ChangeRequestSCMHead) {
                ContributorMetadataAction cma;
                envs.putIfNotNull("CHANGE_ID", ((ChangeRequestSCMHead)head).getId());
                SCMHead target = ((ChangeRequestSCMHead)head).getTarget();
                envs.put("CHANGE_TARGET", target.getName());
                ObjectMetadataAction oma = branch.getAction(ObjectMetadataAction.class);
                if (oma != null) {
                    envs.putIfNotNull("CHANGE_URL", oma.getObjectUrl());
                    envs.putIfNotNull("CHANGE_TITLE", oma.getObjectDisplayName());
                }
                if ((cma = branch.getAction(ContributorMetadataAction.class)) != null) {
                    envs.putIfNotNull("CHANGE_AUTHOR", cma.getContributor());
                    envs.putIfNotNull("CHANGE_AUTHOR_DISPLAY_NAME", cma.getContributorDisplayName());
                    envs.putIfNotNull("CHANGE_AUTHOR_EMAIL", cma.getContributorEmail());
                }
            }
        }
    }
}

