/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactoryDescriptor;
import jenkins.branch.BranchProperty;
import jenkins.branch.DescriptorOrder;
import jenkins.branch.JobDecorator;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.ProjectDecorator;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class BranchProjectFactory<P extends Job<P, R>, R extends Run<P, R>>
extends AbstractDescribableImpl<BranchProjectFactory<?, ?>>
implements Saveable,
ExtensionPoint {
    @CheckForNull
    private MultiBranchProject<P, R> owner = null;

    public abstract P newInstance(Branch var1);

    public void save() throws IOException {
        if (this.owner != null) {
            this.owner.save();
        }
    }

    public void setOwner(MultiBranchProject<P, R> owner) {
        this.owner = owner;
    }

    public MultiBranchProject<P, R> getOwner() {
        return this.owner;
    }

    @NonNull
    public abstract Branch getBranch(@NonNull P var1);

    @NonNull
    public abstract P setBranch(@NonNull P var1, @NonNull Branch var2);

    public abstract boolean isProject(@CheckForNull Item var1);

    @NonNull
    public P asProject(@NonNull Item item) {
        return (P)((Job)item);
    }

    @CheckForNull
    public SCMRevision getRevision(P project) {
        XmlFile file = new XmlFile(new File(project.getRootDir(), "scm-revision-hash.xml"));
        try {
            return (SCMRevision)file.read();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setRevisionHash(P project, SCMRevision revision) throws IOException {
        XmlFile file = new XmlFile(new File(project.getRootDir(), "scm-revision-hash.xml"));
        file.write((Object)revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P decorate(P project) {
        if (!this.isProject((Item)project)) {
            return project;
        }
        Branch branch = this.getBranch(project);
        BulkChange bc = new BulkChange(project);
        try {
            ArrayList<BranchProperty> properties = new ArrayList<BranchProperty>(branch.getProperties());
            Collections.sort(properties, DescriptorOrder.reverse(BranchProperty.class));
            for (BranchProperty property : properties) {
                JobDecorator decorator = property.jobDecorator(project.getClass());
                if (decorator == null) continue;
                if (project instanceof Project && decorator instanceof ProjectDecorator) {
                    DescribableList publishersList = ((Project)project).getPublishersList();
                    DescribableList buildWrappersList = ((Project)project).getBuildWrappersList();
                    List<Publisher> list = ((ProjectDecorator)decorator).publishers(publishersList.toList());
                    List<BuildWrapper> buildWrappers = ((ProjectDecorator)decorator).buildWrappers(buildWrappersList.toList());
                    publishersList.replaceBy(list);
                    buildWrappersList.replaceBy(buildWrappers);
                }
                List<JobProperty<?>> jobProperties = decorator.jobProperties(project.getAllProperties());
                for (JobProperty jobProperty : project.getAllProperties()) {
                    project.removeProperty(jobProperty);
                }
                for (JobProperty jobProperty : jobProperties) {
                    project.addProperty(jobProperty);
                }
                decorator.project(project);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            bc.abort();
        }
        return project;
    }

    @NonNull
    public BranchProjectFactoryDescriptor getDescriptor() {
        return (BranchProjectFactoryDescriptor)super.getDescriptor();
    }

    @NonNull
    public final Class<P> getProjectClass() {
        return this.getDescriptor().getProjectClass();
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class SourceByItemImpl
    extends SCMSource.SourceByItem {
        public SCMSource getSource(Item item) {
            BranchProjectFactory projectFactory;
            ItemGroup parent;
            if (item instanceof Job && (parent = item.getParent()) instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject(item)) {
                String sourceId = projectFactory.getBranch(projectFactory.asProject(item)).getSourceId();
                return ((MultiBranchProject)parent).getSCMSource(sourceId);
            }
            return null;
        }
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class HeadByItemImpl
    extends SCMHead.HeadByItem {
        public SCMHead getHead(Item item) {
            BranchProjectFactory projectFactory;
            ItemGroup parent;
            if (item instanceof Job && (parent = item.getParent()) instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject(item)) {
                return projectFactory.getBranch(projectFactory.asProject(item)).getHead();
            }
            return null;
        }
    }
}

