/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ListView;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.DescribableList;
import hudson.views.JobColumn;
import hudson.views.StatusColumn;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.branch.BranchCategoryFilter;
import jenkins.branch.BranchStatusColumn;
import jenkins.branch.ItemColumn;
import jenkins.branch.LocalizedViewsTabBar;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHeadCategory;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class MultiBranchProjectViewHolder
extends AbstractFolderViewHolder {
    @NonNull
    private final MultiBranchProject<?, ?> owner;
    private transient ViewsTabBar tabBar;
    @GuardedBy(value="this")
    private transient List<View> views = null;
    @GuardedBy(value="this")
    private transient String primaryView = null;

    public MultiBranchProjectViewHolder(MultiBranchProject<?, ?> owner) {
        this.owner = owner;
    }

    @NonNull
    public synchronized List<View> getViews() {
        if (this.owner.getItems().isEmpty()) {
            return Collections.singletonList(this.owner.getWelcomeView());
        }
        if (this.views == null) {
            ArrayList<View> views = new ArrayList<View>();
            for (SCMHeadCategory c : SCMHeadCategory.collectAndSimplify(this.owner.getSCMSources()).values()) {
                views.add((View)new ViewImpl((ViewGroup)this.owner, c));
                if (!c.isUncategorized()) continue;
                this.primaryView = c.getName();
            }
            this.views = views;
        }
        return this.views;
    }

    public void setViews(@NonNull List<? extends View> views) {
    }

    public synchronized String getPrimaryView() {
        if (this.owner.getItems().isEmpty()) {
            return "welcome";
        }
        if (this.primaryView == null) {
            this.getViews();
        }
        return this.primaryView;
    }

    public void setPrimaryView(@CheckForNull String name) {
    }

    public boolean isPrimaryModifiable() {
        return false;
    }

    @NonNull
    public ViewsTabBar getTabBar() {
        if (this.tabBar == null) {
            this.tabBar = new LocalizedViewsTabBar();
        }
        return this.tabBar;
    }

    public void setTabBar(@NonNull ViewsTabBar tabBar) {
    }

    public boolean isTabBarModifiable() {
        return false;
    }

    public synchronized void invalidateCaches() {
        this.views = null;
        this.primaryView = null;
    }

    @Restricted(value={NoExternalUse.class})
    public static class ViewImpl
    extends ListView {
        @NonNull
        private final SCMHeadCategory category;

        public ViewImpl(ViewGroup owner, @NonNull SCMHeadCategory category) {
            super(category.getName(), owner);
            this.category = category;
            try {
                this.getJobFilters().replaceBy(Collections.singletonList(new BranchCategoryFilter(category)));
                DescribableList columns = this.getColumns();
                columns.replace((Object)columns.get(StatusColumn.class), (Object)new BranchStatusColumn());
                columns.replace((Object)columns.get(JobColumn.class), (Object)new ItemColumn());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setRecurse(false);
        }

        public String getDisplayName() {
            return this.category.getDisplayName().toString();
        }

        public boolean isRecurse() {
            return false;
        }

        public ACL getACL() {
            final ACL acl = super.getACL();
            return new ACL(){

                public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                    if (View.CREATE.equals((Object)permission) || View.CONFIGURE.equals((Object)permission) || View.DELETE.equals((Object)permission)) {
                        return false;
                    }
                    return acl.hasPermission(a, permission);
                }
            };
        }

        public void save() throws IOException {
        }

        @Extension
        public static class ViewDescriptorImpl
        extends ViewDescriptor {
            public String getDisplayName() {
                return "Multibranch Project All view";
            }

            public boolean isInstantiable() {
                return false;
            }
        }
    }
}

