/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public final class NameMangler {
    private static final int MAX_SAFE_LENGTH = 32;
    private static final int MIN_HASH_LENGTH = 6;
    private static final int MAX_HASH_LENGTH = 12;

    private NameMangler() {
        throw new IllegalAccessError("Utility class");
    }

    public static String apply(String name) {
        String digest;
        if (name.length() <= 32) {
            boolean unsafe = false;
            boolean first = true;
            Object object = name.toCharArray();
            int n = ((char[])object).length;
            for (int i = 0; i < n; ++i) {
                char c = object[i];
                if (first) {
                    if (c == '-') {
                        unsafe = true;
                        break;
                    }
                    first = false;
                }
                if (NameMangler.isSafe(c)) continue;
                unsafe = true;
                break;
            }
            if (!unsafe) {
                switch (name.toLowerCase(Locale.ENGLISH)) {
                    case ".": 
                    case "..": 
                    case "con": 
                    case "prn": 
                    case "aux": 
                    case "nul": 
                    case "com1": 
                    case "com2": 
                    case "com3": 
                    case "com4": 
                    case "com5": 
                    case "com6": 
                    case "com7": 
                    case "com8": 
                    case "com9": 
                    case "lpt1": 
                    case "lpt2": 
                    case "lpt3": 
                    case "lpt4": 
                    case "lpt5": 
                    case "lpt6": 
                    case "lpt7": 
                    case "lpt8": 
                    case "lpt9": {
                        unsafe = true;
                        break;
                    }
                    default: {
                        if (!name.endsWith(".")) break;
                        unsafe = true;
                    }
                }
            }
            if (!unsafe) {
                return name;
            }
        }
        StringBuilder buf = new StringBuilder(name.length() + 16);
        for (char c : name.toCharArray()) {
            if (NameMangler.isSafe(c)) {
                buf.append(c);
                continue;
            }
            if (c == '/' || c == '\\' || c == ' ' || c == '.' || c == '_') {
                if (buf.length() == 0) {
                    buf.append("0-");
                    continue;
                }
                buf.append('-');
                continue;
            }
            if (c <= '\u00ff') {
                if (buf.length() == 0) {
                    buf.append("0_");
                } else {
                    buf.append('_');
                }
                buf.append(StringUtils.leftPad((String)Integer.toHexString(c & 0xFF), (int)2, (char)'0'));
                continue;
            }
            if (buf.length() == 0) {
                buf.append("0_");
            } else {
                buf.append('_');
            }
            buf.append(StringUtils.leftPad((String)Integer.toHexString((c & 0xFFFF) >> 8 & 0xFF), (int)2, (char)'0'));
            buf.append('_');
            buf.append(StringUtils.leftPad((String)Integer.toHexString(c & 0xFF), (int)2, (char)'0'));
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] bytes = sha.digest(name.getBytes(StandardCharsets.UTF_8));
            int bits = 0;
            int data = 0;
            StringBuffer dd = new StringBuffer(32);
            for (byte b : bytes) {
                while (bits >= 5) {
                    dd.append(NameMangler.toDigit(data & 0x1F));
                    bits -= 5;
                    data >>= 5;
                }
                data |= (b & 0xFF) << bits;
                bits += 8;
            }
            digest = dd.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 not installed", e);
        }
        if (buf.length() <= 25) {
            buf.append('.');
            buf.append(StringUtils.right((String)digest, (int)6));
            return buf.toString();
        }
        int overage = buf.length() - 32;
        String hash = overage <= 6 ? "." + StringUtils.right((String)digest, (int)6) + "." : (overage > 12 ? "." + StringUtils.right((String)digest, (int)12) + "." : "." + StringUtils.right((String)digest, (int)overage) + ".");
        int start = (32 - hash.length()) / 2;
        buf.delete(start, start + hash.length() + overage);
        buf.insert(start, hash);
        return buf.toString();
    }

    private static char toDigit(int n) {
        return (char)(n < 10 ? 48 + n : 97 + n - 10);
    }

    private static boolean isSafe(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || '-' == c;
    }
}

