/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.google.common.base.Charsets;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.slaves.WorkspaceLocator;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=-100.0)
@Restricted(value={NoExternalUse.class})
public class WorkspaceLocatorImpl
extends WorkspaceLocator {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceLocatorImpl.class.getName());
    static int PATH_MAX = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".PATH_MAX", 80);

    public FilePath locate(TopLevelItem item, Node node) {
        if (PATH_MAX == 0) {
            return null;
        }
        if (!(item.getParent() instanceof MultiBranchProject)) {
            return null;
        }
        String minimized = WorkspaceLocatorImpl.minimize(item.getFullName());
        if (node instanceof Jenkins) {
            return ((Jenkins)node).getRootPath().child("workspace/" + minimized);
        }
        if (node instanceof Slave) {
            FilePath root = ((Slave)node).getWorkspaceRoot();
            return root != null ? root.child(minimized) : null;
        }
        return null;
    }

    static String uniqueSuffix(String name) {
        byte[] sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(name.getBytes(Charsets.UTF_16LE));
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError("https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#MessageDigest", x);
        }
        return new Base32(0).encodeToString(sha256).replaceFirst("=+$", "");
    }

    static String minimize(String name) {
        String mnemonic = name.replaceAll("(%[0-9A-F]{2}|[^a-zA-Z0-9-_.])+", "_");
        int maxSuffix = 53;
        int maxMnemonic = Math.max(PATH_MAX - maxSuffix, 1);
        if (maxSuffix + maxMnemonic > PATH_MAX) {
            LOGGER.log(Level.WARNING, "WorkspaceLocatorImpl.PATH_MAX is small enough that workspace path collisions are more likely to occur");
            int minSuffix = 11;
            maxMnemonic = Math.max((PATH_MAX - 11) / 2, 1);
            maxSuffix = Math.max(PATH_MAX - maxMnemonic, 11);
        }
        String result = StringUtils.right((String)mnemonic, (int)maxMnemonic) + "-" + WorkspaceLocatorImpl.uniqueSuffix(name).substring(0, --maxSuffix);
        return result;
    }

    @Extension
    public static class Deleter
    extends ItemListener {
        public void onDeleted(Item item) {
            if (item.getParent() instanceof MultiBranchProject) {
                String suffix = WorkspaceLocatorImpl.uniqueSuffix(item.getFullName());
                Jenkins jenkins = Jenkins.getActiveInstance();
                this.cleanUp(suffix, jenkins.getRootPath().child("workspace"), (Node)jenkins);
                for (Node node : jenkins.getNodes()) {
                    if (!(node instanceof Slave)) continue;
                    this.cleanUp(suffix, ((Slave)node).getWorkspaceRoot(), node);
                }
            }
        }

        private void cleanUp(String suffix, FilePath root, Node node) {
            try {
                if (root == null || !root.isDirectory()) {
                    return;
                }
                for (FilePath child : root.listDirectories()) {
                    if (!child.getName().contains(suffix)) continue;
                    LOGGER.log(Level.INFO, "deleting obsolete workspace {0} on {1}", new Object[]{child, node.getNodeName()});
                    child.deleteRecursive();
                }
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, "could not clean up workspace directories under " + root + " on " + node.getNodeName(), x);
            }
        }
    }
}

