/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.io.IOException;
import jenkins.branch.Messages;
import jenkins.model.Jenkins;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class DescriptionColumn
extends ListViewColumn {
    @DataBoundConstructor
    public DescriptionColumn() {
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public ObjectMetadataAction getPropertyOf(Item item) {
        if (item instanceof Actionable) {
            return (ObjectMetadataAction)((Actionable)item).getAction(ObjectMetadataAction.class);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public String description(@CheckForNull Object p, @NonNull Object job) throws IOException {
        if (p instanceof ObjectMetadataAction) {
            String description;
            String objectDescription = ((ObjectMetadataAction)p).getObjectDescription();
            String string = description = objectDescription == null ? null : Util.escape((String)objectDescription);
            if (StringUtils.isNotBlank((String)description)) {
                return description;
            }
        }
        if (job instanceof Job) {
            return Jenkins.getActiveInstance().getMarkupFormatter().translate(((Job)job).getDescription());
        }
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.DescriptionColumn_displayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

