/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.util.AlternativeUiTextProvider;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class TaskNounUiTextProvider
extends AlternativeUiTextProvider {
    private static final Logger LOGGER = Logger.getLogger(TaskNounUiTextProvider.class.getName());
    private final AlternativeUiTextProvider.Message<AbstractItem> taskNoun;

    public TaskNounUiTextProvider() {
        AlternativeUiTextProvider.Message message;
        try {
            Field taskNoun = AbstractItem.class.getDeclaredField("TASK_NOUN");
            message = (AlternativeUiTextProvider.Message)taskNoun.get(null);
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.FINE, "This version of Jenkins does not have AbstractItem.TASK_NOUN", e);
            message = null;
        }
        catch (ClassCastException | IllegalAccessException e) {
            LOGGER.log(Level.WARNING, "Could not access AbstractItem.TASK_NOUN by reflection", e);
            message = null;
        }
        this.taskNoun = message;
    }

    public <T> String getText(AlternativeUiTextProvider.Message<T> text, T context) {
        if (text == this.taskNoun && (context instanceof MultiBranchProject || context instanceof OrganizationFolder)) {
            return Messages.TaskNounUiTextProvider_TaskNoun();
        }
        return null;
    }
}

