/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildnamesetter;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.EnvironmentVarSetter;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class Executor {
    private final Run run;
    private final TaskListener listener;

    public Executor(Run run, TaskListener listener) {
        this.run = run;
        this.listener = listener;
    }

    public void setName(String nameTemplate) {
        try {
            String name = this.evaluateMacro(nameTemplate);
            this.listener.getLogger().println("New run name is '" + name + "'");
            this.run.setDisplayName(name);
            this.setVariable(nameTemplate);
        }
        catch (IOException e) {
            this.listener.error(e.getMessage());
        }
        catch (MacroEvaluationException e) {
            this.listener.getLogger().println("Failed to evaluate name macro:" + e.toString());
        }
    }

    public void setDescription(String descriptionTemplate) {
        if (StringUtils.isEmpty((String)descriptionTemplate)) {
            return;
        }
        try {
            String description = this.evaluateMacro(descriptionTemplate);
            this.listener.getLogger().println("New run description is '" + description + "'");
            this.run.setDescription(description);
        }
        catch (IOException e) {
            this.listener.error(e.getMessage());
        }
        catch (MacroEvaluationException e) {
            this.listener.getLogger().println("Failed to evaluate description macro:" + e.toString());
        }
    }

    public void setVariable(String nameTemplate) throws MacroEvaluationException {
        if (!(this.run instanceof AbstractBuild)) {
            return;
        }
        AbstractBuild abstractBuild = (AbstractBuild)this.run;
        EnvironmentVarSetter.setVar(abstractBuild, "BUILD_DISPLAY_NAME", this.evaluateMacro(nameTemplate), this.listener.getLogger());
    }

    public String evaluateMacro(String template) throws MacroEvaluationException {
        try {
            File workspace = this.run.getRootDir();
            return TokenMacro.expandAll((Run)this.run, (FilePath)new FilePath(workspace), (TaskListener)this.listener, (String)template);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

