/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.impl.Messages;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;

public class LikelyStuckTimeOutStrategy
extends BuildTimeOutStrategy {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public LikelyStuckTimeOutStrategy() {
    }

    @Override
    public long getTimeOut(@Nonnull AbstractBuild<?, ?> run, @Nonnull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        Executor executor = run.getExecutor();
        if (executor == null) {
            return TimeUnit.HOURS.toMillis(24L);
        }
        Queue.Executable executable = executor.getCurrentExecutable();
        if (executable == null) {
            return TimeUnit.HOURS.toMillis(24L);
        }
        long eta = executable.getEstimatedDuration();
        if (eta >= 0L) {
            return eta * 10L;
        }
        return TimeUnit.HOURS.toMillis(24L);
    }

    @Override
    public Descriptor<BuildTimeOutStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends BuildTimeOutStrategyDescriptor {
        public String getDisplayName() {
            return Messages.LikelyStuckTimeOutStrategy_DisplayName();
        }
    }
}

