/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SSHCheckoutTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public SSHCheckoutTrait(@CheckForNull String credentialsId) {
        this.credentialsId = "ANONYMOUS".equals(credentialsId) ? null : Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        if (builder instanceof GitSCMBuilder) {
            ((BitbucketGitSCMBuilder)builder).withCredentials(this.credentialsId, BitbucketRepositoryProtocol.SSH);
        }
    }

    @Symbol(value={"bitbucketSshCheckout"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHCheckoutTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return BitbucketSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return BitbucketSCMSource.class;
        }

        public boolean isApplicableToBuilder(@NonNull Class<? extends SCMBuilder> builderClass) {
            return BitbucketGitSCMBuilder.class.isAssignableFrom(builderClass);
        }

        public boolean isApplicableToSCM(@NonNull SCMDescriptor<?> scm) {
            return scm instanceof GitSCM.DescriptorImpl;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            StandardListBoxModel result = new StandardListBoxModel();
            result.add(Messages.SSHCheckoutTrait_useAgentKey(), "");
            return result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class));
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String value) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.error((String)Messages.SSHCheckoutTrait_incompatibleCredentials());
            }
            return FormValidation.warning((String)Messages.SSHCheckoutTrait_missingCredentials());
        }
    }
}

