/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import jenkins.authentication.tokens.api.AuthenticationTokenContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class BitbucketAuthenticator {
    private final String id;
    public static final String SERVER_URL = "bitbucket.server.uri";
    public static final String SCHEME = "bitbucket.server.uri.scheme";
    public static final String BITBUCKET_INSTANCE_TYPE = "bitbucket.server.type";
    public static final String BITBUCKET_INSTANCE_TYPE_CLOUD = "BITBUCKET_CLOUD";
    public static final String BITBUCKET_INSTANCE_TYPE_SERVER = "BITBUCKET_SERVER";

    public BitbucketAuthenticator(StandardCredentials credentials) {
        this.id = credentials.getId();
    }

    public String getId() {
        return this.id;
    }

    public void configureBuilder(HttpClientBuilder builder) {
    }

    public void configureContext(HttpClientContext context, HttpHost host) {
    }

    public void configureRequest(HttpRequest request) {
    }

    public StandardUsernameCredentials getCredentialsForScm() {
        return null;
    }

    public BitbucketHref addAuthToken(BitbucketHref bitbucketHref) {
        return bitbucketHref;
    }

    public static AuthenticationTokenContext<BitbucketAuthenticator> authenticationContext(String serverUrl) {
        if (serverUrl == null) {
            serverUrl = "https://bitbucket.org";
        }
        String scheme = serverUrl.split(":")[0].toLowerCase();
        boolean isCloud = serverUrl.equals("https://bitbucket.org");
        return AuthenticationTokenContext.builder(BitbucketAuthenticator.class).with((Object)SERVER_URL, (Object)serverUrl).with((Object)SCHEME, (Object)scheme).with((Object)BITBUCKET_INSTANCE_TYPE, (Object)(isCloud ? BITBUCKET_INSTANCE_TYPE_CLOUD : BITBUCKET_INSTANCE_TYPE_SERVER)).build();
    }
}

