/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.util.Secret;
import org.apache.http.HttpRequest;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitbucketAccessTokenAuthenticator
extends BitbucketAuthenticator {
    private final Secret token;

    public BitbucketAccessTokenAuthenticator(StringCredentials credentials) {
        super((StandardCredentials)credentials);
        this.token = credentials.getSecret();
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.setHeader("Authorization", "Bearer " + this.token.getPlainText());
    }

    @Override
    public StandardUsernameCredentials getCredentialsForScm() {
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, null, "", this.token.getPlainText());
    }
}

