/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketOAuth;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketOAuthService;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import org.apache.http.HttpRequest;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.Token;

public class BitbucketOAuthAuthenticator
extends BitbucketAuthenticator {
    private Token token;

    public BitbucketOAuthAuthenticator(StandardUsernamePasswordCredentials credentials) {
        super((StandardCredentials)credentials);
        OAuthConfig config = new OAuthConfig(credentials.getUsername(), credentials.getPassword().getPlainText());
        BitbucketOAuthService OAuthService2 = (BitbucketOAuthService)new BitbucketOAuth().createService(config);
        this.token = OAuthService2.getAccessToken(OAuthConstants.EMPTY_TOKEN, null);
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.addHeader("Authorization", "Bearer " + this.token.getToken());
    }

    @Override
    public StandardUsernameCredentials getCredentialsForScm() {
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, null, "", this.token.getToken());
    }
}

