/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.filesystem;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFileSystem;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import jenkins.scm.api.SCMFile;

public class BitbucketSCMFile
extends SCMFile {
    private final BitbucketApi api;
    private String ref;
    private final String hash;

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @Deprecated
    public BitbucketSCMFile(BitbucketSCMFileSystem bitBucketSCMFileSystem, BitbucketApi api, String ref) {
        this(bitBucketSCMFileSystem, api, ref, null);
    }

    public BitbucketSCMFile(BitbucketSCMFileSystem bitBucketSCMFileSystem, BitbucketApi api, String ref, String hash) {
        this.type(SCMFile.Type.DIRECTORY);
        this.api = api;
        this.ref = ref;
        this.hash = hash;
    }

    @Deprecated
    public BitbucketSCMFile(@NonNull BitbucketSCMFile parent, String name, SCMFile.Type type) {
        this(parent, name, type, null);
    }

    public BitbucketSCMFile(@NonNull BitbucketSCMFile parent, String name, SCMFile.Type type, String hash) {
        super((SCMFile)parent, name);
        this.api = parent.api;
        this.ref = parent.ref;
        this.hash = hash;
        this.type(type);
    }

    public String getHash() {
        return this.hash;
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            return this.api.getDirectoryContent(this);
        }
        throw new IOException("Cannot get children from a regular file");
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            throw new IOException("Cannot get raw content from a directory");
        }
        return this.api.getFileContent(this);
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new BitbucketSCMFile(this, name, assumeIsDirectory ? SCMFile.Type.DIRECTORY : SCMFile.Type.REGULAR_FILE, this.hash);
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        return this.getType();
    }
}

