/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;

public class BitbucketGitSCMRevision
extends AbstractGitSCMSource.SCMRevisionImpl {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String author;
    private final Date date;

    public BitbucketGitSCMRevision(@NonNull SCMHead head, @NonNull BitbucketCommit commit) {
        super(head, commit.getHash());
        this.message = commit.getMessage();
        this.author = commit.getAuthor();
        Date commitDate = null;
        try {
            if (commit.getDate() != null) {
                commitDate = new StdDateFormat().parse(commit.getDate());
            }
        }
        catch (ParseException e) {
            commitDate = null;
        }
        this.date = commitDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
            return false;
        }
        AbstractGitSCMSource.SCMRevisionImpl that = (AbstractGitSCMSource.SCMRevisionImpl)o;
        return Objects.equals(this.getHash(), that.getHash()) && Objects.equals(this.getHead(), that.getHead());
    }

    public int hashCode() {
        return Objects.hash(this.getHash(), this.getHead());
    }
}

