/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BranchWithHash;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;

public class FallbackToOtherRepositoryGitSCMExtension
extends GitSCMExtension {
    private final String cloneLink;
    private final String remoteName;
    private final List<BranchWithHash> branchWithHashes;

    public FallbackToOtherRepositoryGitSCMExtension(String cloneLink, String remoteName, List<BranchWithHash> branchWithHashes) {
        this.cloneLink = cloneLink;
        this.remoteName = remoteName;
        this.branchWithHashes = branchWithHashes;
    }

    public Revision decorateRevisionToBuild(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision marked, Revision rev) throws InterruptedException {
        List refSpecs = this.branchWithHashes.stream().filter(branchWithHash -> !FallbackToOtherRepositoryGitSCMExtension.commitExists(git, branchWithHash.getHash())).map(branchWithHash -> {
            String branch = branchWithHash.getBranch();
            return new RefSpec("+refs/heads/" + branch + ":refs/remotes/" + this.remoteName + "/" + branch);
        }).collect(Collectors.toList());
        if (!refSpecs.isEmpty()) {
            URIish remote;
            FetchCommand fetchCommand = git.fetch_();
            try {
                remote = new URIish(this.cloneLink);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            fetchCommand.from(remote, refSpecs).execute();
        }
        return rev;
    }

    private static boolean commitExists(GitClient git, String sha1) {
        try {
            git.revParse(sha1);
            return true;
        }
        catch (GitException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

