/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractBitbucketEndpointDescriptor
extends Descriptor<AbstractBitbucketEndpoint> {
    @Restricted(value={NoExternalUse.class})
    public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl) {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.MANAGE);
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl)));
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public static FormValidation doCheckBitbucketJenkinsRootUrl(@QueryParameter String value) {
        String url = Util.fixEmptyAndTrim((String)value);
        if (url == null) {
            return FormValidation.ok();
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
        }
        return FormValidation.ok();
    }
}

