/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(HookProcessor.class.getName());

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void process(String payload, BitbucketType instanceType) {
    }

    public abstract void process(HookEventType var1, String var2, BitbucketType var3, String var4);

    public void process(HookEventType type, String payload, BitbucketType instanceType, String origin, String serverUrl) {
        this.process(type, payload, instanceType, origin);
    }

    protected void scmSourceReIndex(String owner, String repository) {
        try (ACLContext context = ACL.as((Authentication)ACL.SYSTEM);){
            boolean reindexed = false;
            for (SCMSourceOwner scmOwner : SCMSourceOwners.all()) {
                List sources = scmOwner.getSCMSources();
                for (SCMSource source : sources) {
                    if (!(source instanceof BitbucketSCMSource) || !((BitbucketSCMSource)source).getRepoOwner().equalsIgnoreCase(owner) || !((BitbucketSCMSource)source).getRepository().equals(repository)) continue;
                    LOGGER.log(Level.INFO, "Multibranch project found, reindexing " + scmOwner.getName());
                    scmOwner.onSCMSourceUpdated(source);
                    reindexed = true;
                }
            }
            if (!reindexed) {
                LOGGER.log(Level.INFO, "No multibranch project matching for reindex on {0}/{1}", new Object[]{owner, repository});
            }
        }
    }
}

