/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BranchWithHash;
import com.cloudbees.jenkins.plugins.bitbucket.FallbackToOtherRepositoryGitSCMExtension;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.BitbucketServer;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.util.List;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang.StringUtils;

public class BitbucketGitSCMBuilder
extends GitSCMBuilder<BitbucketGitSCMBuilder> {
    @NonNull
    private final BitbucketSCMSource scmSource;
    @NonNull
    private List<BitbucketHref> primaryCloneLinks = List.of();
    @NonNull
    private List<BitbucketHref> mirrorCloneLinks = List.of();
    @NonNull
    private BitbucketRepositoryProtocol protocol = BitbucketRepositoryProtocol.HTTP;

    public BitbucketGitSCMBuilder(@NonNull BitbucketSCMSource scmSource, @NonNull SCMHead head, @CheckForNull SCMRevision revision, @CheckForNull String credentialsId) {
        super(head, revision, scmSource.getServerUrl(), credentialsId);
        this.scmSource = scmSource;
        String serverURL = scmSource.getServerUrl();
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(serverURL);
        if (endpoint == null) {
            endpoint = new BitbucketServerEndpoint(null, serverURL, false, null);
        }
        String repositoryURL = endpoint.getRepositoryUrl(scmSource.getRepoOwner(), scmSource.getRepository());
        if (BitbucketApiUtils.isCloud(endpoint.getServerUrl())) {
            this.withBrowser((GitRepositoryBrowser)new BitbucketWeb(repositoryURL));
        } else {
            this.withBrowser((GitRepositoryBrowser)new BitbucketServer(repositoryURL));
        }
        this.withCredentials(credentialsId, null);
    }

    public BitbucketGitSCMBuilder withCloneLinks(@CheckForNull List<BitbucketHref> primaryCloneLinks, @CheckForNull List<BitbucketHref> mirrorCloneLinks) {
        if (primaryCloneLinks == null) {
            throw new IllegalArgumentException("Primary clone links shouldn't be null");
        }
        this.primaryCloneLinks = primaryCloneLinks;
        this.mirrorCloneLinks = Util.fixNull(mirrorCloneLinks);
        return this.withBitbucketRemote();
    }

    @NonNull
    public BitbucketSCMSource scmSource() {
        return this.scmSource;
    }

    @NonNull
    public BitbucketGitSCMBuilder withCredentials(String credentialsId, BitbucketRepositoryProtocol protocol) {
        if (StringUtils.isNotBlank((String)credentialsId)) {
            StandardCredentials credentials = BitbucketCredentials.lookupCredentials(this.scmSource.getServerUrl(), this.scmSource.getOwner(), "SAME".equals(this.scmSource.getCheckoutCredentialsId()) ? credentialsId : this.scmSource.getCheckoutCredentialsId(), StandardCredentials.class);
            if (protocol == null) {
                protocol = credentials instanceof SSHUserPrivateKey ? BitbucketRepositoryProtocol.SSH : BitbucketRepositoryProtocol.HTTP;
            }
        } else if (protocol == null) {
            protocol = BitbucketRepositoryProtocol.HTTP;
        }
        this.protocol = protocol;
        return (BitbucketGitSCMBuilder)this.withCredentials(credentialsId);
    }

    @NonNull
    public BitbucketGitSCMBuilder withBitbucketRemote() {
        SCMHead head = this.head();
        String headName = head.getName();
        if (head instanceof PullRequestSCMHead) {
            PullRequestSCMHead prHead = (PullRequestSCMHead)head;
            this.withPullRequestRemote(prHead, headName);
        } else if (head instanceof TagSCMHead) {
            this.withTagRemote(headName);
        } else {
            this.withBranchRemote(headName);
        }
        return this;
    }

    private void withPullRequestRemote(PullRequestSCMHead head, String headName) {
        String scmSourceRepoOwner = this.scmSource.getRepoOwner();
        String scmSourceRepository = this.scmSource.getRepository();
        String pullRequestRepoOwner = head.getRepoOwner();
        String pullRequestRepository = head.getRepository();
        boolean prFromTargetRepository = pullRequestRepoOwner.equals(scmSourceRepoOwner) && pullRequestRepository.equals(scmSourceRepository);
        SCMRevision revision = this.revision();
        ChangeRequestCheckoutStrategy checkoutStrategy = head.getCheckoutStrategy();
        boolean cloneFromMirror = prFromTargetRepository && !this.mirrorCloneLinks.isEmpty() && revision instanceof PullRequestSCMRevision;
        String targetBranch = head.getTarget().getName();
        String branchName = head.getBranchName();
        if (prFromTargetRepository) {
            this.withRefSpec("+refs/heads/" + branchName + ":refs/remotes/@{remote}/" + branchName);
            if (cloneFromMirror) {
                PullRequestSCMRevision pullRequestSCMRevision = (PullRequestSCMRevision)revision;
                String primaryRemoteName = this.remoteName().equals("primary") ? "primary-primary" : "primary";
                String cloneLink = this.getCloneLink(this.primaryCloneLinks);
                List<BranchWithHash> branchWithHashes = checkoutStrategy == ChangeRequestCheckoutStrategy.MERGE ? List.of(new BranchWithHash(branchName, pullRequestSCMRevision.getPull().getHash()), new BranchWithHash(targetBranch, pullRequestSCMRevision.getTargetImpl().getHash())) : List.of(new BranchWithHash(branchName, pullRequestSCMRevision.getPull().getHash()));
                this.withExtension(new FallbackToOtherRepositoryGitSCMExtension(cloneLink, primaryRemoteName, branchWithHashes));
                this.withMirrorRemote();
            } else {
                this.withPrimaryRemote();
            }
        } else if (this.scmSource.isCloud()) {
            this.withRefSpec("+refs/heads/" + branchName + ":refs/remotes/@{remote}/" + headName);
            String cloneLink = this.getCloudRepositoryUri(pullRequestRepoOwner, pullRequestRepository);
            this.withRemote(cloneLink);
        } else {
            String pullId = head.getId();
            this.withRefSpec("+refs/pull-requests/" + pullId + "/from:refs/remotes/@{remote}/" + headName);
            this.withPrimaryRemote();
        }
        if (head.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.MERGE) {
            String hash = revision instanceof PullRequestSCMRevision ? ((PullRequestSCMRevision)revision).getTargetImpl().getHash() : null;
            String refSpec = "+refs/heads/" + targetBranch + ":refs/remotes/@{remote}/" + targetBranch;
            if (!prFromTargetRepository && this.scmSource.isCloud()) {
                String upstreamRemoteName = this.remoteName().equals("upstream") ? "upstream-upstream" : "upstream";
                this.withAdditionalRemote(upstreamRemoteName, this.getCloneLink(this.primaryCloneLinks), new String[]{refSpec});
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + upstreamRemoteName + "/" + targetBranch, hash));
            } else {
                this.withRefSpec(refSpec);
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + this.remoteName() + "/" + targetBranch, hash));
            }
        }
    }

    @NonNull
    public String getCloudRepositoryUri(@NonNull String owner, @NonNull String repository) {
        switch (this.protocol) {
            case HTTP: {
                return "https://bitbucket.org/" + owner + "/" + repository + ".git";
            }
            case SSH: {
                return "ssh://git@bitbucket.org/" + owner + "/" + repository + ".git";
            }
        }
        throw new IllegalArgumentException("Unsupported repository protocol: " + this.protocol);
    }

    private void withTagRemote(String headName) {
        this.withRefSpec("+refs/tags/" + headName + ":refs/tags/" + headName);
        if (this.mirrorCloneLinks.isEmpty()) {
            this.withPrimaryRemote();
        } else {
            this.withMirrorRemote();
        }
    }

    private void withBranchRemote(String headName) {
        this.withRefSpec("+refs/heads/" + headName + ":refs/remotes/@{remote}/" + headName);
        if (this.mirrorCloneLinks.isEmpty()) {
            this.withPrimaryRemote();
        } else {
            this.withMirrorRemote();
        }
    }

    private void withPrimaryRemote() {
        String cloneLink = this.getCloneLink(this.primaryCloneLinks);
        this.withRemote(cloneLink);
    }

    private void withMirrorRemote() {
        String cloneLink = this.getCloneLink(this.mirrorCloneLinks);
        this.withRemote(cloneLink);
    }

    private String getCloneLink(List<BitbucketHref> cloneLinks) {
        return cloneLinks.stream().filter(link -> this.protocol.matches(link.getName())).findAny().orElseThrow(() -> new IllegalStateException("Can't find clone link for protocol " + this.protocol)).getHref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        this.withBitbucketRemote();
        SCMHead head = this.head();
        SCMRevision rev = this.revision();
        try {
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                this.withHead(new SCMHead(prHead.getBranchName()));
                if (rev instanceof PullRequestSCMRevision) {
                    PullRequestSCMRevision prRev = (PullRequestSCMRevision)rev;
                    this.withRevision((SCMRevision)prRev.getPull());
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(head);
            this.withRevision(rev);
        }
    }
}

