/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketLink;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigatorContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigatorRequest;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTeamMetadataAction;
import com.cloudbees.jenkins.plugins.bitbucket.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.ForkPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.OriginPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.PublicRepoPullRequestFilterTrait;
import com.cloudbees.jenkins.plugins.bitbucket.SSHCheckoutTrait;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistration;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistrationTrait;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.MirrorListSupplier;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerWebhookImplementation;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerProject;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.util.FormFillFailure;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCategory;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.UncategorizedSCMSourceCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.RegexSCMSourceFilterTrait;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BitbucketSCMNavigator
extends SCMNavigator {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    @NonNull
    private String serverUrl = "https://bitbucket.org";
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String mirrorId;
    @NonNull
    private final String repoOwner;
    @CheckForNull
    private String projectKey;
    @NonNull
    private List<SCMTrait<? extends SCMTrait<?>>> traits;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String checkoutCredentialsId;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String pattern;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient boolean autoRegisterHooks;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String includes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String excludes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String bitbucketServerUrl;

    @DataBoundConstructor
    public BitbucketSCMNavigator(String repoOwner) {
        this.repoOwner = repoOwner;
        this.traits = new ArrayList();
        this.credentialsId = null;
    }

    @Deprecated
    public BitbucketSCMNavigator(String repoOwner, String credentialsId, String checkoutCredentialsId) {
        this.repoOwner = repoOwner;
        this.traits = new ArrayList();
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(true, true));
        this.traits.add((SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
        this.traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustEveryone()));
        this.traits.add((SCMTrait<SCMTrait<?>>)new PublicRepoPullRequestFilterTrait());
        if (checkoutCredentialsId != null && !"SAME".equals(checkoutCredentialsId)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() throws ObjectStreamException {
        if (this.serverUrl == null) {
            this.serverUrl = BitbucketEndpointConfiguration.get().readResolveServerUrl(this.bitbucketServerUrl);
        }
        if (this.serverUrl == null) {
            LOGGER.log(Level.WARNING, "BitbucketSCMNavigator::readResolve : serverUrl is still empty");
        }
        if (this.traits == null) {
            this.traits = new ArrayList();
            this.traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(true, true));
            this.traits.add((SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
            this.traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustEveryone()));
            this.traits.add((SCMTrait<SCMTrait<?>>)new PublicRepoPullRequestFilterTrait());
            if (this.includes != null && !"*".equals(this.includes) || this.excludes != null && !"".equals(this.excludes)) {
                this.traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(StringUtils.defaultIfBlank((String)this.includes, (String)"*"), StringUtils.defaultIfBlank((String)this.excludes, (String)"")));
            }
            if (this.checkoutCredentialsId != null && !"SAME".equals(this.checkoutCredentialsId) && !this.checkoutCredentialsId.equals(this.credentialsId)) {
                this.traits.add((SCMTrait<SCMTrait<?>>)new SSHCheckoutTrait(this.checkoutCredentialsId));
            }
            this.traits.add((SCMTrait<SCMTrait<?>>)new WebhookRegistrationTrait(this.autoRegisterHooks ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
            if (this.pattern != null && !".*".equals(this.pattern)) {
                this.traits.add((SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(this.pattern));
            }
        }
        return this;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public String getMirrorId() {
        return this.mirrorId;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    @DataBoundSetter
    public void setProjectKey(@CheckForNull String projectKey) {
        this.projectKey = Util.fixEmpty((String)projectKey);
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @DataBoundSetter
    public void setMirrorId(String mirrorId) {
        this.mirrorId = Util.fixEmpty((String)mirrorId);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull SCMTrait[] traits) {
        this.traits = new ArrayList();
        if (traits != null) {
            for (SCMTrait trait : traits) {
                this.traits.add(trait);
            }
        }
    }

    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
        this.traits = traits != null ? new ArrayList(traits) : new ArrayList();
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        if (!StringUtils.equals((String)this.serverUrl, (String)(serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl)))) {
            this.serverUrl = serverUrl;
            this.resetId();
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setPattern(String pattern) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof RegexSCMSourceFilterTrait)) continue;
            if (".*".equals(pattern)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(pattern));
            }
            return;
        }
        if (!".*".equals(pattern)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(pattern));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setAutoRegisterHooks(boolean autoRegisterHook) {
        this.traits.removeIf(trait -> trait instanceof WebhookRegistrationTrait);
        this.traits.add((SCMTrait<SCMTrait<?>>)new WebhookRegistrationTrait(autoRegisterHook ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean isAutoRegisterHooks() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WebhookRegistrationTrait)) continue;
            return ((WebhookRegistrationTrait)sCMTrait).getMode() != WebhookRegistration.DISABLE;
        }
        return true;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getCheckoutCredentialsId() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof SSHCheckoutTrait)) continue;
            return StringUtils.defaultString((String)((SSHCheckoutTrait)sCMTrait).getCredentialsId(), (String)"ANONYMOUS");
        }
        return "SAME";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setCheckoutCredentialsId(String checkoutCredentialsId) {
        this.traits.removeIf(trait -> trait instanceof SSHCheckoutTrait);
        if (checkoutCredentialsId != null && !"SAME".equals(checkoutCredentialsId)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public String getPattern() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof RegexSCMSourceFilterTrait)) continue;
            return ((RegexSCMSourceFilterTrait)sCMTrait).getRegex();
        }
        return ".*";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBitbucketServerUrl(String url) {
        url = BitbucketEndpointConfiguration.normalizeServerUrl(url);
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(url);
        if (endpoint != null) {
            this.setServerUrl(url);
            return;
        }
        LOGGER.log(Level.WARNING, "Call to legacy setBitbucketServerUrl({0}) method is configuring a url missing from the global configuration.", url);
        this.setServerUrl(url);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getBitbucketServerUrl() {
        if (BitbucketEndpointConfiguration.get().findEndpoint(this.serverUrl) instanceof BitbucketCloudEndpoint) {
            return null;
        }
        return this.serverUrl;
    }

    @NonNull
    public String getEndpointJenkinsRootUrl() {
        return AbstractBitbucketEndpoint.getEndpointJenkinsRootUrl(this.serverUrl);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getIncludes() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)sCMTrait).getIncludes();
        }
        return "*";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setIncludes(@NonNull String includes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(includes) && "".equals(existing.getExcludes())) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(includes, existing.getExcludes()));
            }
            return;
        }
        if (!"*".equals(includes)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(includes, ""));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getExcludes() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)sCMTrait).getExcludes();
        }
        return "";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setExcludes(@NonNull String excludes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(existing.getIncludes()) && "".equals(excludes)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(existing.getIncludes(), excludes));
            }
            return;
        }
        if (!"".equals(excludes)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait("*", excludes));
        }
    }

    @NonNull
    protected String id() {
        return this.serverUrl + "::" + this.repoOwner;
    }

    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        TaskListener listener = observer.getListener();
        if (StringUtils.isBlank((String)this.repoOwner)) {
            listener.getLogger().format("Must specify a repository owner%n", new Object[0]);
            return;
        }
        StandardCredentials credentials = BitbucketCredentials.lookupCredentials(this.serverUrl, observer.getContext(), this.credentialsId, StandardCredentials.class);
        if (credentials == null) {
            listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.serverUrl);
        } else {
            listener.getLogger().format("Connecting to %s using %s%n", this.serverUrl, CredentialsNameProvider.name((Credentials)credentials));
        }
        try (BitbucketSCMNavigatorRequest request = ((BitbucketSCMNavigatorContext)new BitbucketSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);){
            SourceFactory sourceFactory = new SourceFactory(request);
            WitnessImpl witness = new WitnessImpl(request, listener);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverUrl), (Credentials)credentials);
            BitbucketApi bitbucket = BitbucketApiFactory.newInstance(this.serverUrl, authenticator, this.repoOwner, this.projectKey, null);
            BitbucketTeam team = bitbucket.getTeam();
            if (team != null) {
                listener.getLogger().format("Looking up repositories of team %s%n", this.repoOwner);
                request.withRepositories(bitbucket.getRepositories());
            } else {
                listener.getLogger().format("Looking up repositories of user %s%n", this.repoOwner);
                request.withRepositories(bitbucket.getRepositories(UserRoleInRepository.ADMIN));
            }
            for (BitbucketRepository repo : request.repositories()) {
                if (!request.process(repo.getRepositoryName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) continue;
                listener.getLogger().format("%d repositories were processed (query completed)%n", witness.getCount());
            }
            listener.getLogger().format("%d repositories were processed%n", witness.getCount());
        }
    }

    @NonNull
    public List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().printf("Looking up team details of %s...%n", this.getRepoOwner());
        ArrayList<Action> result = new ArrayList<Action>();
        StandardCredentials credentials = BitbucketCredentials.lookupCredentials(this.serverUrl, (SCMSourceOwner)owner, this.credentialsId, StandardCredentials.class);
        if (credentials == null) {
            listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.serverUrl);
        } else {
            listener.getLogger().format("Connecting to %s using %s%n", this.serverUrl, CredentialsNameProvider.name((Credentials)credentials));
        }
        BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverUrl), (Credentials)credentials);
        BitbucketApi bitbucket = BitbucketApiFactory.newInstance(this.serverUrl, authenticator, this.repoOwner, null, null);
        BitbucketTeam team = bitbucket.getTeam();
        if (team != null) {
            String defaultTeamUrl = team instanceof BitbucketServerProject ? this.serverUrl + "/projects/" + team.getName() : this.serverUrl + "/" + team.getName();
            String teamUrl = StringUtils.defaultIfBlank((String)team.getLink("html"), (String)defaultTeamUrl);
            String teamDisplayName = StringUtils.defaultIfBlank((String)team.getDisplayName(), (String)team.getName());
            result.add((Action)new ObjectMetadataAction(teamDisplayName, null, teamUrl));
            result.add((Action)new BitbucketTeamMetadataAction(this.serverUrl, credentials, team.getName()));
            result.add(new BitbucketLink("icon-bitbucket-logo", teamUrl));
            listener.getLogger().printf("Team: %s%n", HyperlinkNote.encodeTo((String)teamUrl, (String)teamDisplayName));
        } else {
            String teamUrl = this.serverUrl + "/" + this.repoOwner;
            result.add((Action)new ObjectMetadataAction(this.repoOwner, null, teamUrl));
            result.add((Action)new BitbucketTeamMetadataAction(null, null, null));
            result.add(new BitbucketLink("icon-bitbucket-logo", teamUrl));
            listener.getLogger().println("Could not resolve team details");
        }
        return result;
    }

    private class SourceFactory
    implements SCMNavigatorRequest.SourceLambda {
        private final BitbucketSCMNavigatorRequest request;

        public SourceFactory(BitbucketSCMNavigatorRequest request) {
            this.request = request;
        }

        @NonNull
        public SCMSource create(@NonNull String projectName) throws IOException, InterruptedException {
            return ((BitbucketSCMSourceBuilder)new BitbucketSCMSourceBuilder(BitbucketSCMNavigator.this.getId() + "::" + projectName, BitbucketSCMNavigator.this.serverUrl, BitbucketSCMNavigator.this.credentialsId, BitbucketSCMNavigator.this.repoOwner, projectName, BitbucketSCMNavigator.this.mirrorId).withRequest(this.request)).build();
        }
    }

    private static class WitnessImpl
    implements SCMNavigatorRequest.Witness {
        private int count;
        private final BitbucketSCMNavigatorRequest request;
        private final TaskListener listener;

        public WitnessImpl(BitbucketSCMNavigatorRequest request, TaskListener listener) {
            this.request = request;
            this.listener = listener;
        }

        public void record(@NonNull String name, boolean isMatch) {
            BitbucketRepository repository = this.request.getBitbucketRepository(name);
            if (isMatch) {
                this.listener.getLogger().format("Proposing %s%n", repository.getFullName());
                ++this.count;
            } else {
                this.listener.getLogger().format("Ignoring %s%n", repository.getFullName());
            }
        }

        public int getCount() {
            return this.count;
        }
    }

    @Symbol(value={"bitbucket"})
    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";

        public String getDisplayName() {
            return Messages.BitbucketSCMNavigator_DisplayName();
        }

        public String getDescription() {
            return Messages.BitbucketSCMNavigator_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-scmnavigator.svg";
        }

        public String getIconClassName() {
            return "icon-bitbucket-scm-navigator";
        }

        public SCMNavigator newInstance(String name) {
            BitbucketSCMNavigator instance = new BitbucketSCMNavigator(StringUtils.defaultString((String)name));
            instance.setTraits(this.getTraitsDefaults());
            return instance;
        }

        public boolean isServerUrlSelectable() {
            return BitbucketEndpointConfiguration.get().isEndpointSelectable();
        }

        public ListBoxModel doFillServerUrlItems(@AncestorInPath SCMSourceOwner context) {
            Jenkins contextToCheck;
            Object object = contextToCheck = context == null ? Jenkins.get() : context;
            if (!contextToCheck.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return BitbucketEndpointConfiguration.get().getEndpointItems();
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String value) {
            return BitbucketCredentials.checkCredentialsId(context, value, serverUrl);
        }

        public static FormValidation doCheckMirrorId(@QueryParameter String value, @QueryParameter String serverUrl) {
            BitbucketServerWebhookImplementation webhookImplementation;
            if (!value.isEmpty() && (webhookImplementation = BitbucketServerEndpoint.findWebhookImplementation(serverUrl)) == BitbucketServerWebhookImplementation.PLUGIN) {
                return FormValidation.error((String)"Mirror can only be used with native webhooks");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            return BitbucketCredentials.fillCredentialsIdItems(context, serverUrl);
        }

        public ListBoxModel doFillMirrorIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner) throws FormFillFailure {
            return BitbucketApiUtils.getFromBitbucket(context, serverUrl, credentialsId, repoOwner, null, MirrorListSupplier.INSTANCE);
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            BitbucketSCMSource.DescriptorImpl sourceDescriptor = (BitbucketSCMSource.DescriptorImpl)Jenkins.get().getDescriptorByType(BitbucketSCMSource.DescriptorImpl.class);
            ArrayList all = new ArrayList();
            all.addAll(SCMNavigatorTrait._for((SCMNavigatorDescriptor)this, BitbucketSCMNavigatorContext.class, BitbucketSCMSourceBuilder.class));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, BitbucketSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, null, BitbucketGitSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)"Repositories", it -> it instanceof SCMNavigatorTraitDescriptor, (boolean)true, result);
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            int insertionPoint = result.size();
            NamedArrayList.select(all, (String)"Git", it -> GitSCM.class.isAssignableFrom(it.getScmClass()), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result, (int)insertionPoint);
            return result;
        }

        @NonNull
        public List<SCMTrait<? extends SCMTrait<?>>> getTraitsDefaults() {
            return Arrays.asList(new SCMTrait[]{new BranchDiscoveryTrait(true, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks())});
        }

        @NonNull
        protected SCMSourceCategory[] createCategories() {
            return new SCMSourceCategory[]{new UncategorizedSCMSourceCategory(Messages._BitbucketSCMNavigator_UncategorizedSCMSourceCategory_DisplayName())};
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-bitbucket-scm-navigator icon-sm", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-scmnavigator.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-scm-navigator icon-md", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-scmnavigator.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-scm-navigator icon-lg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-scmnavigator.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-scm-navigator icon-xlg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-scmnavigator.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-sm", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-logo.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-md", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-logo.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-lg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-logo.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-xlg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-logo.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo icon-sm", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo icon-md", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo icon-lg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo icon-xlg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo-git icon-sm", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository-git.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo-git icon-md", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository-git.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo-git icon-lg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository-git.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-repo-git icon-xlg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-repository-git.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-branch icon-sm", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-branch.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-branch icon-md", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-branch.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-branch icon-lg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-branch.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-branch icon-xlg", "plugin/cloudbees-bitbucket-branch-source/images/bitbucket-branch.svg", "width: 48px; height: 48px;"));
        }
    }
}

