/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketDefaultBranch;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketLink;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketRepoMetadataAction;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.ForkPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.GitClientAuthenticatorExtension;
import com.cloudbees.jenkins.plugins.bitbucket.LazyIterable;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.OriginPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.PublicRepoPullRequestFilterTrait;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.SSHCheckoutTrait;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistration;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistrationTrait;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepositoryDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketProject;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.impl.extension.BitbucketEnvVarExtension;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.MirrorListSupplier;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerWebhookImplementation;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerAPIClient;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormFillFailure;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BitbucketSCMSource
extends SCMSource {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    private static final String CLOUD_REPO_TEMPLATE = "{/owner,repo}";
    private static final String SERVER_REPO_TEMPLATE = "/projects{/owner}/repos{/repo}";
    private static int eventDelaySeconds = Math.min(300, Math.max(0, Integer.getInteger(BitbucketSCMSource.class.getName() + ".eventDelaySeconds", 5)));
    @NonNull
    private String serverUrl = "https://bitbucket.org";
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String mirrorId;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @NonNull
    private List<SCMSourceTrait> traits;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String checkoutCredentialsId;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String includes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String excludes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient boolean autoRegisterHook;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String bitbucketServerUrl;
    @CheckForNull
    private transient Map<String, String> pullRequestTitleCache;
    @CheckForNull
    private transient Map<String, ContributorMetadataAction> pullRequestContributorCache;
    @CheckForNull
    private transient List<BitbucketHref> primaryCloneLinks = null;
    @CheckForNull
    private transient List<BitbucketHref> mirrorCloneLinks = null;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void aliases() {
        Items.XSTREAM2.addCompatibilityAlias("com.cloudbees.jenkins.plugins.bitbucket.MergeWithGitSCMExtension", MergeWithGitSCMExtension.class);
    }

    @DataBoundConstructor
    public BitbucketSCMSource(@NonNull String repoOwner, @NonNull String repository) {
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.traits = new ArrayList<SCMSourceTrait>();
    }

    @Deprecated
    public BitbucketSCMSource(@CheckForNull String id, @NonNull String repoOwner, @NonNull String repository) {
        this(repoOwner, repository);
        this.setId(id);
        this.traits.add(new BranchDiscoveryTrait(true, true));
        this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)));
        this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks()));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() throws ObjectStreamException {
        if (this.serverUrl == null) {
            this.serverUrl = BitbucketEndpointConfiguration.get().readResolveServerUrl(this.bitbucketServerUrl);
        }
        if (this.serverUrl == null) {
            LOGGER.log(Level.WARNING, "BitbucketSCMSource::readResolve : serverUrl is still empty");
        }
        if (this.traits == null) {
            this.traits = new ArrayList<SCMSourceTrait>();
            if (!"*".equals(this.includes) || !"".equals(this.excludes)) {
                this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(this.includes, this.excludes));
            }
            if (this.checkoutCredentialsId != null && !"SAME".equals(this.checkoutCredentialsId) && !this.checkoutCredentialsId.equals(this.credentialsId)) {
                this.traits.add(new SSHCheckoutTrait(this.checkoutCredentialsId));
            }
            this.traits.add(new WebhookRegistrationTrait(this.autoRegisterHook ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
            this.traits.add(new BranchDiscoveryTrait(true, true));
            this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
            this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustEveryone()));
            this.traits.add(new PublicRepoPullRequestFilterTrait());
        }
        return this;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getMirrorId() {
        return this.mirrorId;
    }

    @DataBoundSetter
    public void setMirrorId(String mirrorId) {
        this.mirrorId = Util.fixEmpty((String)mirrorId);
    }

    @NonNull
    public String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public String getRepository() {
        return this.repository;
    }

    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@CheckForNull String serverUrl) {
        this.serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl);
    }

    @NonNull
    public String getEndpointJenkinsRootUrl() {
        return AbstractBitbucketEndpoint.getEndpointJenkinsRootUrl(this.serverUrl);
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBitbucketServerUrl(String url) {
        url = BitbucketEndpointConfiguration.normalizeServerUrl(url);
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(url);
        if (endpoint != null) {
            this.setServerUrl(endpoint.getServerUrl());
        } else {
            LOGGER.log(Level.WARNING, "Call to legacy setBitbucketServerUrl({0}) method is configuring a url missing from the global configuration.", url);
            this.setServerUrl(url);
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getBitbucketServerUrl() {
        String serverUrl = this.getServerUrl();
        if (BitbucketEndpointConfiguration.get().findEndpoint(serverUrl) instanceof BitbucketCloudEndpoint) {
            return null;
        }
        return serverUrl;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getCheckoutCredentialsId() {
        for (SCMSourceTrait t : this.traits) {
            if (!(t instanceof SSHCheckoutTrait)) continue;
            SSHCheckoutTrait sshTrait = (SSHCheckoutTrait)t;
            return StringUtils.defaultString((String)sshTrait.getCredentialsId(), (String)"ANONYMOUS");
        }
        return "SAME";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setCheckoutCredentialsId(String checkoutCredentialsId) {
        this.traits.removeIf(trait -> trait instanceof SSHCheckoutTrait);
        if (checkoutCredentialsId != null && !"SAME".equals(checkoutCredentialsId)) {
            this.traits.add(new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getIncludes() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait wildcardTrait = (WildcardSCMHeadFilterTrait)trait;
            return wildcardTrait.getIncludes();
        }
        return "*";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setIncludes(@NonNull String includes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(includes) && "".equals(existing.getExcludes())) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, existing.getExcludes()));
            }
            return;
        }
        if (!"*".equals(includes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, ""));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getExcludes() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)trait).getExcludes();
        }
        return "";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setExcludes(@NonNull String excludes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(existing.getIncludes()) && "".equals(excludes)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(existing.getIncludes(), excludes));
            }
            return;
        }
        if (!"".equals(excludes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait("*", excludes));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setAutoRegisterHook(boolean autoRegisterHook) {
        this.traits.removeIf(trait -> trait instanceof WebhookRegistrationTrait);
        this.traits.add(new WebhookRegistrationTrait(autoRegisterHook ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean isAutoRegisterHook() {
        for (SCMSourceTrait t : this.traits) {
            if (!(t instanceof WebhookRegistrationTrait)) continue;
            return ((WebhookRegistrationTrait)t).getMode() != WebhookRegistration.DISABLE;
        }
        return true;
    }

    public BitbucketApi buildBitbucketClient() {
        return this.buildBitbucketClient(this.repoOwner, this.repository);
    }

    public BitbucketApi buildBitbucketClient(PullRequestSCMHead head) {
        return this.buildBitbucketClient(head.getRepoOwner(), head.getRepository());
    }

    public BitbucketApi buildBitbucketClient(String repoOwner, String repository) {
        return BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), repoOwner, null, repository);
    }

    public void afterSave() {
        try {
            this.gatherPrimaryCloneLinks(this.buildBitbucketClient());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Could not determine clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to generated links", e);
        }
    }

    private void gatherPrimaryCloneLinks(@NonNull BitbucketApi apiClient) throws IOException, InterruptedException {
        BitbucketRepository r = apiClient.getRepository();
        Map<String, List<BitbucketHref>> links = r.getLinks();
        if (links != null && links.containsKey("clone")) {
            this.setPrimaryCloneLinks(links.get("clone"));
        }
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, final @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(criteria, observer).withTraits(this.traits)).newRequest(this, listener);){
            StandardCredentials scanCredentials = this.credentials();
            if (scanCredentials == null) {
                listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.getServerUrl());
            } else {
                listener.getLogger().format("Connecting to %s using %s%n", this.getServerUrl(), CredentialsNameProvider.name((Credentials)scanCredentials));
            }
            final BitbucketApi apiClient = this.buildBitbucketClient();
            this.gatherPrimaryCloneLinks(apiClient);
            if (request.isFetchPRs()) {
                request.setPullRequests((Iterable<BitbucketPullRequest>)new LazyIterable<BitbucketPullRequest>(){

                    @Override
                    protected Iterable<BitbucketPullRequest> create() {
                        try {
                            if (event instanceof HasPullRequests) {
                                HasPullRequests hasPrEvent = (HasPullRequests)event;
                                return BitbucketSCMSource.this.getBitbucketPullRequestsFromEvent(hasPrEvent, listener);
                            }
                            return apiClient.getPullRequests();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchBranches()) {
                request.setBranches((Iterable<BitbucketBranch>)new LazyIterable<BitbucketBranch>(){

                    @Override
                    protected Iterable<BitbucketBranch> create() {
                        try {
                            return apiClient.getBranches();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchTags()) {
                request.setTags((Iterable<BitbucketBranch>)new LazyIterable<BitbucketBranch>(){

                    @Override
                    protected Iterable<BitbucketBranch> create() {
                        try {
                            return apiClient.getTags();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchBranches() && !request.isComplete()) {
                this.retrieveBranches(request);
            }
            if (request.isFetchPRs() && !request.isComplete()) {
                this.retrievePullRequests(request);
            }
            if (request.isFetchTags() && !request.isComplete()) {
                this.retrieveTags(request);
            }
        }
        catch (WrappedException e) {
            e.unwrap();
        }
    }

    private Iterable<BitbucketPullRequest> getBitbucketPullRequestsFromEvent(@NonNull HasPullRequests incomingPrEvent, @NonNull TaskListener listener) {
        BitbucketApi bitBucket = this.buildBitbucketClient();
        HashSet<BitbucketPullRequest> initializedPRs = new HashSet<BitbucketPullRequest>();
        try {
            Iterable<BitbucketPullRequest> pullRequests = incomingPrEvent.getPullRequests(this);
            for (BitbucketPullRequest pr : pullRequests) {
                initializedPRs.add(bitBucket.getPullRequestById(Integer.parseInt(pr.getId())));
                listener.getLogger().format("Initialized PR: %s%n", pr.getLink());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new WrappedException(e);
        }
        return initializedPRs;
    }

    private void retrievePullRequests(final BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        final BitbucketApi originBitbucket = this.buildBitbucketClient();
        if (request.isSkipPublicPRs() && !originBitbucket.isPrivate()) {
            request.listener().getLogger().printf("Skipping pull requests for %s (public repository)%n", fullName);
            return;
        }
        request.listener().getLogger().printf("Looking up %s for pull requests%n", fullName);
        HashSet<String> livePRs = new HashSet<String>();
        int count = 0;
        Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies = request.getPRStrategies();
        for (final BitbucketPullRequest pull : request.getPullRequests()) {
            class Skip
            extends IOException {
                Skip() {
                }
            }
            String originalBranchName = pull.getSource().getBranch().getName();
            request.listener().getLogger().printf("Checking PR-%s from %s and branch %s%n", pull.getId(), pull.getSource().getRepository().getFullName(), originalBranchName);
            boolean fork = !fullName.equalsIgnoreCase(pull.getSource().getRepository().getFullName());
            String pullRepoOwner = pull.getSource().getRepository().getOwnerName();
            String pullRepository = pull.getSource().getRepository().getRepositoryName();
            BitbucketApi pullBitbucket = fork && BitbucketApiUtils.isCloud(originBitbucket) ? BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), pullRepoOwner, null, pullRepository) : originBitbucket;
            ++count;
            livePRs.add(pull.getId());
            this.getPullRequestTitleCache().put(pull.getId(), StringUtils.defaultString((String)pull.getTitle()));
            this.getPullRequestContributorCache().put(pull.getId(), new ContributorMetadataAction(pull.getAuthorIdentifier(), pull.getAuthorLogin(), pull.getAuthorEmail()));
            try {
                for (ChangeRequestCheckoutStrategy strategy : strategies.get(fork)) {
                    PullRequestSCMHead head;
                    String branchName = "PR-" + pull.getId();
                    if (strategies.get(fork).size() > 1) {
                        branchName = "PR-" + pull.getId() + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
                    }
                    if (!request.process(head = new PullRequestSCMHead(branchName, pullRepoOwner, pullRepository, originalBranchName, pull, this.originOf(pullRepoOwner, pullRepository), strategy), () -> new BranchHeadCommit(pull.getSource().getBranch()), new BitbucketProbeFactory(pullBitbucket, request), new BitbucketRevisionFactory<BitbucketCommit>(pullBitbucket){

                        @Override
                        @NonNull
                        public SCMRevision create(@NonNull SCMHead head, @Nullable BitbucketCommit sourceCommit) throws IOException, InterruptedException {
                            try {
                                BranchHeadCommit targetCommit = new BranchHeadCommit(pull.getDestination().getBranch());
                                return super.create(head, sourceCommit, targetCommit);
                            }
                            catch (BitbucketRequestException e) {
                                if (originBitbucket instanceof BitbucketCloudApiClient && e.getHttpCode() == 403) {
                                    request.listener().getLogger().printf("Skipping %s because of %s%n", pull.getId(), HyperlinkNote.encodeTo((String)"https://bitbucket.org/site/master/issues/5814/reify-pull-requests-by-making-them-a-ref", (String)"a permission issue accessing pull requests from forks"));
                                    throw new Skip();
                                }
                                e.printStackTrace(request.listener().getLogger());
                                if (e.getHttpCode() == 403) {
                                    throw new Skip();
                                }
                                throw e;
                            }
                        }
                    }, new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
                    request.listener().getLogger().format("%n  %d pull requests were processed (query completed)%n", count);
                    return;
                }
            }
            catch (Skip e) {
                request.listener().getLogger().println("Do not have permission to view PR from " + pull.getSource().getRepository().getFullName() + " and branch " + originalBranchName);
            }
        }
        request.listener().getLogger().format("%n  %d pull requests were processed%n", count);
        this.getPullRequestTitleCache().keySet().retainAll(livePRs);
        this.getPullRequestContributorCache().keySet().retainAll(livePRs);
    }

    private void retrieveBranches(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for branches");
        BitbucketApi bitbucket = this.buildBitbucketClient();
        int count = 0;
        for (BitbucketBranch branch : request.getBranches()) {
            request.listener().getLogger().println("Checking branch " + branch.getName() + " from " + fullName);
            ++count;
            if (!request.process(new BranchSCMHead(branch.getName()), () -> new BranchHeadCommit(branch), new BitbucketProbeFactory(bitbucket, request), new BitbucketRevisionFactory(bitbucket), new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
            request.listener().getLogger().format("%n  %d branches were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d branches were processed%n", count);
    }

    private void retrieveTags(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for tags");
        BitbucketApi bitbucket = this.buildBitbucketClient();
        int count = 0;
        for (BitbucketBranch tag : request.getTags()) {
            request.listener().getLogger().println("Checking tag " + tag.getName() + " from " + fullName);
            ++count;
            if (!request.process((SCMHead)new BitbucketTagSCMHead(tag.getName(), tag.getDateMillis()), tag::getRawNode, new BitbucketProbeFactory(bitbucket, request), new BitbucketRevisionFactory(bitbucket), new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
            request.listener().getLogger().format("%n  %d tags were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d tags were processed%n", count);
    }

    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        BitbucketApi bitbucket = this.buildBitbucketClient();
        try {
            if (head instanceof PullRequestSCMHead) {
                BitbucketCommit sourceRevision;
                BitbucketCommit targetRevision;
                PullRequestSCMHead h = (PullRequestSCMHead)head;
                if (bitbucket instanceof BitbucketCloudApiClient) {
                    BitbucketBranch targetBranch = bitbucket.getBranch(h.getTarget().getName());
                    if (targetBranch == null) {
                        listener.getLogger().format("No branch found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, h.getTarget().getName());
                        return null;
                    }
                    targetRevision = this.findCommit(targetBranch, listener);
                    if (targetRevision == null) {
                        listener.getLogger().format("No branch found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, h.getTarget().getName());
                        return null;
                    }
                    BitbucketBranch branch = head.getOrigin() == SCMHeadOrigin.DEFAULT ? bitbucket.getBranch(h.getBranchName()) : this.buildBitbucketClient(h).getBranch(h.getBranchName());
                    if (branch == null) {
                        listener.getLogger().format("No branch found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, head.getName());
                        return null;
                    }
                    sourceRevision = this.findCommit(branch, listener);
                } else {
                    BitbucketPullRequest pr;
                    try {
                        pr = bitbucket.getPullRequestById(Integer.parseInt(h.getId()));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Cannot parse the PR id {0}", h.getId());
                        return null;
                    }
                    targetRevision = this.findPRDestinationCommit(pr, listener);
                    if (targetRevision == null) {
                        listener.getLogger().format("No branch found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, h.getTarget().getName());
                        return null;
                    }
                    sourceRevision = this.findPRSourceCommit(pr, listener);
                }
                if (sourceRevision == null) {
                    listener.getLogger().format("No revision found in {0}/{1} for PR-{2} [{3}]", h.getRepoOwner(), h.getRepository(), h.getId(), h.getBranchName());
                    return null;
                }
                return new PullRequestSCMRevision(h, new BitbucketGitSCMRevision(h.getTarget(), targetRevision), new BitbucketGitSCMRevision(h, sourceRevision));
            }
            if (head instanceof BitbucketTagSCMHead) {
                BitbucketTagSCMHead tagHead = (BitbucketTagSCMHead)head;
                BitbucketBranch tag = bitbucket.getTag(tagHead.getName());
                if (tag == null) {
                    listener.getLogger().format("No tag found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, head.getName());
                    return null;
                }
                BitbucketCommit revision = this.findCommit(tag, listener);
                if (revision == null) {
                    listener.getLogger().format("No revision found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, head.getName());
                    return null;
                }
                return new BitbucketTagSCMRevision(tagHead, revision);
            }
            BitbucketBranch branch = bitbucket.getBranch(head.getName());
            if (branch == null) {
                listener.getLogger().format("No branch found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, head.getName());
                return null;
            }
            BitbucketCommit revision = this.findCommit(branch, listener);
            if (revision == null) {
                listener.getLogger().format("No revision found in {0}/{1} with name [{2}]", this.repoOwner, this.repository, head.getName());
                return null;
            }
            return new BitbucketGitSCMRevision(head, revision);
        }
        catch (IOException e) {
            if (e instanceof BitbucketRequestException) {
                BitbucketRequestException bre = (BitbucketRequestException)e;
                SCMSourceOwner scmSourceOwner = this.getOwner();
                if (bre.getHttpCode() == 401 && scmSourceOwner != null) {
                    LOGGER.log(Level.WARNING, "BitbucketRequestException: Authz error. Status: 401 for Item '{0}' using credentialId '{1}'", new Object[]{scmSourceOwner.getFullDisplayName(), this.getCredentialsId()});
                }
            }
            throw e;
        }
    }

    private BitbucketCommit findCommit(@NonNull BitbucketBranch branch, TaskListener listener) {
        String revision = branch.getRawNode();
        if (revision == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in branch %s%n", branch.getName());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in branch %s. Perhaps you are using Bitbucket Server previous to 4.x%n", branch.getName());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    private BitbucketCommit findPRSourceCommit(BitbucketPullRequest pr, TaskListener listener) {
        BitbucketBranch branch = pr.getSource().getBranch();
        String hash = branch.getRawNode();
        if (hash == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s%n", pr.getId());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s. Perhaps you are using Bitbucket Server previous to 4.x%n", pr.getId());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    private BitbucketCommit findPRDestinationCommit(BitbucketPullRequest pr, TaskListener listener) {
        BitbucketBranch branch = pr.getDestination().getBranch();
        String hash = branch.getRawNode();
        if (hash == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s%n", pr.getId());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s. Perhaps you are using Bitbucket Server previous to 4.x%n", pr.getId());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        this.initCloneLinks();
        boolean sshAuth = this.traits.stream().anyMatch(SSHCheckoutTrait.class::isInstance);
        BitbucketAuthenticator authenticator = this.authenticator();
        return ((BitbucketGitSCMBuilder)((BitbucketGitSCMBuilder)((BitbucketGitSCMBuilder)new BitbucketGitSCMBuilder(this, head, revision, this.credentialsId).withExtension(new GitClientAuthenticatorExtension(authenticator == null || sshAuth ? null : authenticator.getCredentialsForSCM()))).withExtension(new BitbucketEnvVarExtension(this.getRepoOwner(), this.getRepository(), this.getProjectKey(), this.getServerUrl()))).withCloneLinks(this.primaryCloneLinks, this.mirrorCloneLinks).withTraits(this.traits)).build();
    }

    @Restricted(value={ProtectedExternally.class})
    @CheckForNull
    protected String getProjectKey() {
        String projectKey = null;
        try {
            BitbucketProject project = this.buildBitbucketClient().getRepository().getProject();
            if (project != null) {
                projectKey = project.getKey();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.severe("Failure getting the project key of repository " + this.getRepository() + " : " + e.getMessage());
        }
        return projectKey;
    }

    private void setPrimaryCloneLinks(List<BitbucketHref> links) {
        links.forEach(link -> {
            if (StringUtils.startsWithIgnoreCase((String)link.getName(), (String)"http")) {
                link.setHref(URLUtils.removeAuthority(link.getHref()));
            }
        });
        this.primaryCloneLinks = links;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (!(revision instanceof PullRequestSCMRevision)) return revision;
        PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
        try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest(this, listener);){
            if (request.isTrusted(head)) {
                SCMRevision sCMRevision = revision;
                return sCMRevision;
            }
        }
        catch (WrappedException wrapped) {
            wrapped.unwrap();
        }
        PullRequestSCMRevision rev = (PullRequestSCMRevision)revision;
        listener.getLogger().format("Loading trusted files from base branch %s at %s rather than %s%n", head.getTarget().getName(), rev.getTarget(), rev.getPull());
        return rev.getTarget();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @CheckForNull
    StandardCredentials credentials() {
        return BitbucketCredentials.lookupCredentials(this.getServerUrl(), this.getOwner(), this.getCredentialsId(), StandardCredentials.class);
    }

    @CheckForNull
    BitbucketAuthenticator authenticator() {
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.getServerUrl()), (Credentials)this.credentials());
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        BitbucketApi bitbucket = this.buildBitbucketClient();
        this.gatherPrimaryCloneLinks(bitbucket);
        BitbucketRepository r = bitbucket.getRepository();
        result.add((Action)new BitbucketRepoMetadataAction(r));
        String defaultBranch = bitbucket.getDefaultBranch();
        if (StringUtils.isNotBlank((String)defaultBranch)) {
            result.add((Action)new BitbucketDefaultBranch(this.repoOwner, this.repository, defaultBranch));
        }
        UriTemplate template = BitbucketApiUtils.isCloud(this.getServerUrl()) ? UriTemplate.fromTemplate((String)(this.getServerUrl() + CLOUD_REPO_TEMPLATE)) : UriTemplate.fromTemplate((String)(this.getServerUrl() + SERVER_REPO_TEMPLATE));
        String url = template.set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).expand();
        result.add(new BitbucketLink("icon-bitbucket-repo", url));
        result.add((Action)new ObjectMetadataAction(r.getRepositoryName(), null, url));
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        PullRequestSCMHead prHead;
        UriTemplate template;
        ArrayList<Action> result = new ArrayList<Action>();
        String title = null;
        if ("https://bitbucket.org".equals(this.getServerUrl())) {
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "{/owner,repo}/{branchOrPR}/{prIdOrHead}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository);
            if (head instanceof PullRequestSCMHead) {
                prHead = (PullRequestSCMHead)head;
                template.set("branchOrPR", (Object)"pull-requests").set("prIdOrHead", (Object)prHead.getId());
            } else {
                template.set("branchOrPR", (Object)"branch").set("prIdOrHead", (Object)head.getName());
            }
        } else if (head instanceof PullRequestSCMHead) {
            prHead = (PullRequestSCMHead)head;
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "/projects{/owner}/repos{/repo}/pull-requests/{id}/overview")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("id", (Object)prHead.getId());
        } else {
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "/projects{/owner}/repos{/repo}/compare/commits{?sourceBranch}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("sourceBranch", (Object)("refs/heads/" + head.getName()));
        }
        if (head instanceof PullRequestSCMHead) {
            prHead = (PullRequestSCMHead)head;
            title = this.getPullRequestTitleCache().get(prHead.getId());
            ContributorMetadataAction contributor = this.getPullRequestContributorCache().get(prHead.getId());
            if (contributor != null) {
                result.add((Action)contributor);
            }
        }
        String url = template.expand();
        result.add(new BitbucketLink("icon-bitbucket-branch", url));
        result.add((Action)new ObjectMetadataAction(title, null, url));
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            Actionable actionable = (Actionable)owner;
            for (BitbucketDefaultBranch p : actionable.getActions(BitbucketDefaultBranch.class)) {
                if (!StringUtils.equals((String)this.getRepoOwner(), (String)p.getRepoOwner()) || !StringUtils.equals((String)this.repository, (String)p.getRepository()) || !StringUtils.equals((String)p.getDefaultBranch(), (String)head.getName())) continue;
                result.add((Action)new PrimaryInstanceMetadataAction());
                break;
            }
        }
        return result;
    }

    @NonNull
    private synchronized Map<String, String> getPullRequestTitleCache() {
        if (this.pullRequestTitleCache == null) {
            this.pullRequestTitleCache = new ConcurrentHashMap<String, String>();
        }
        return this.pullRequestTitleCache;
    }

    @NonNull
    private synchronized Map<String, ContributorMetadataAction> getPullRequestContributorCache() {
        if (this.pullRequestContributorCache == null) {
            this.pullRequestContributorCache = new ConcurrentHashMap<String, ContributorMetadataAction>();
        }
        return this.pullRequestContributorCache;
    }

    @NonNull
    public SCMHeadOrigin originOf(@NonNull String repoOwner, @NonNull String repository) {
        if (this.repository.equalsIgnoreCase(repository)) {
            if (this.repoOwner.equalsIgnoreCase(repoOwner)) {
                return SCMHeadOrigin.DEFAULT;
            }
            return new SCMHeadOrigin.Fork(repoOwner);
        }
        return new SCMHeadOrigin.Fork(repoOwner + "/" + repository);
    }

    public static int getEventDelaySeconds() {
        return eventDelaySeconds;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setEventDelaySeconds(int eventDelaySeconds) {
        BitbucketSCMSource.eventDelaySeconds = Math.min(300, Math.max(0, eventDelaySeconds));
    }

    private void initCloneLinks() {
        BitbucketApi bitbucket;
        if (this.primaryCloneLinks == null) {
            bitbucket = this.buildBitbucketClient();
            this.initPrimaryCloneLinks(bitbucket);
            if (this.mirrorId != null && this.mirrorCloneLinks == null) {
                this.initMirrorCloneLinks((BitbucketServerAPIClient)bitbucket, this.mirrorId);
            }
        }
        if (this.mirrorId != null && this.mirrorCloneLinks == null) {
            bitbucket = this.buildBitbucketClient();
            this.initMirrorCloneLinks((BitbucketServerAPIClient)bitbucket, this.mirrorId);
        }
    }

    private void initMirrorCloneLinks(BitbucketServerAPIClient bitbucket, String mirrorIdLocal) {
        try {
            this.mirrorCloneLinks = this.getCloneLinksFromMirror(bitbucket, mirrorIdLocal);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not determine mirror clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to primary server", e);
        }
    }

    private List<BitbucketHref> getCloneLinksFromMirror(BitbucketServerAPIClient bitbucket, String mirrorIdLocal) throws IOException, InterruptedException {
        BitbucketServerRepository r = (BitbucketServerRepository)bitbucket.getRepository();
        List<BitbucketMirroredRepositoryDescriptor> mirrors = bitbucket.getMirrors(r.getId());
        BitbucketMirroredRepositoryDescriptor mirroredRepositoryDescriptor = mirrors.stream().filter(it -> mirrorIdLocal.equals(it.getMirrorServer().getId())).findFirst().orElseThrow(() -> new IllegalStateException("Could not find mirror descriptor for mirror id " + mirrorIdLocal));
        if (!mirroredRepositoryDescriptor.getMirrorServer().isEnabled()) {
            throw new IllegalStateException("Mirror is disabled for mirror id " + mirrorIdLocal);
        }
        Map<String, List<BitbucketHref>> mirrorDescriptorLinks = mirroredRepositoryDescriptor.getLinks();
        if (mirrorDescriptorLinks == null) {
            throw new IllegalStateException("There is no repository descriptor links for mirror id " + mirrorIdLocal);
        }
        List<BitbucketHref> self = mirrorDescriptorLinks.get("self");
        if (self == null || self.isEmpty()) {
            throw new IllegalStateException("There is no self-link for mirror id " + mirrorIdLocal);
        }
        String selfLink = self.get(0).getHref();
        BitbucketMirroredRepository mirroredRepository = bitbucket.getMirroredRepository(selfLink);
        if (!mirroredRepository.isAvailable()) {
            throw new IllegalStateException("Mirrored repository is not available for mirror id " + mirrorIdLocal);
        }
        Map<String, List<BitbucketHref>> mirroredRepositoryLinks = mirroredRepository.getLinks();
        if (mirroredRepositoryLinks == null) {
            throw new IllegalStateException("There is no mirrored repository links for mirror id " + mirrorIdLocal);
        }
        List<BitbucketHref> mirroredRepositoryCloneLinks = mirroredRepositoryLinks.get("clone");
        if (mirroredRepositoryCloneLinks == null) {
            throw new IllegalStateException("There is no mirrored repository clone links for mirror id " + mirrorIdLocal);
        }
        return mirroredRepositoryCloneLinks;
    }

    private void initPrimaryCloneLinks(BitbucketApi bitbucket) {
        try {
            this.setPrimaryCloneLinks(this.getCloneLinksFromPrimary(bitbucket));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not determine clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to generated links", e);
        }
    }

    private List<BitbucketHref> getCloneLinksFromPrimary(BitbucketApi bitbucket) throws IOException, InterruptedException {
        BitbucketRepository r = bitbucket.getRepository();
        Map<String, List<BitbucketHref>> links = r.getLinks();
        if (links == null) {
            throw new IllegalStateException("There is no links");
        }
        List<BitbucketHref> cloneLinksLocal = links.get("clone");
        if (cloneLinksLocal == null) {
            throw new IllegalStateException("There is no clone links");
        }
        return cloneLinksLocal;
    }

    public boolean isCloud() {
        return "https://bitbucket.org".equals(this.serverUrl);
    }

    @Symbol(value={"bitbucket"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";

        public String getDisplayName() {
            return "Bitbucket";
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull SCMSourceOwner context, @QueryParameter String value, @QueryParameter String serverUrl) {
            return BitbucketCredentials.checkCredentialsId(context, value, serverUrl);
        }

        public static FormValidation doCheckServerUrl(@AncestorInPath SCMSourceOwner context, @QueryParameter String value) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.MANAGE) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.error((String)"Unauthorized to validate Server URL");
            }
            if (BitbucketEndpointConfiguration.get().findEndpoint(value) == null) {
                return FormValidation.error((String)("Unregistered Server: " + value));
            }
            return FormValidation.ok();
        }

        public static FormValidation doCheckMirrorId(@QueryParameter String value, @QueryParameter String serverUrl) {
            BitbucketServerWebhookImplementation webhookImplementation;
            if (!value.isEmpty() && (webhookImplementation = BitbucketServerEndpoint.findWebhookImplementation(serverUrl)) == BitbucketServerWebhookImplementation.PLUGIN) {
                return FormValidation.error((String)"Mirror can only be used with native webhooks");
            }
            return FormValidation.ok();
        }

        public boolean isServerUrlSelectable() {
            return BitbucketEndpointConfiguration.get().isEndpointSelectable();
        }

        public ListBoxModel doFillServerUrlItems(@AncestorInPath SCMSourceOwner context) {
            Jenkins contextToCheck;
            Object object = contextToCheck = context == null ? Jenkins.get() : context;
            if (!contextToCheck.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return BitbucketEndpointConfiguration.get().getEndpointItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            return BitbucketCredentials.fillCredentialsIdItems(context, serverUrl);
        }

        @RequirePOST
        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner) throws IOException {
            BitbucketApiUtils.BitbucketSupplier<ListBoxModel> listBoxModelSupplier = bitbucket -> {
                ListBoxModel result = new ListBoxModel();
                BitbucketTeam team = bitbucket.getTeam();
                List<? extends BitbucketRepository> repositories = bitbucket.getRepositories(team != null ? null : UserRoleInRepository.CONTRIBUTOR);
                if (repositories.isEmpty()) {
                    throw FormFillFailure.error((String)Messages.BitbucketSCMSource_NoMatchingOwner(repoOwner)).withSelectionCleared();
                }
                for (BitbucketRepository bitbucketRepository : repositories) {
                    result.add(bitbucketRepository.getRepositoryName());
                }
                return result;
            };
            return BitbucketApiUtils.getFromBitbucket(context, serverUrl, credentialsId, repoOwner, null, listBoxModelSupplier);
        }

        public ListBoxModel doFillMirrorIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner, @QueryParameter String repository) throws FormFillFailure {
            return BitbucketApiUtils.getFromBitbucket(context, serverUrl, credentialsId, repoOwner, repository, MirrorListSupplier.INSTANCE);
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._BitbucketSCMSource_UncategorizedSCMHeadCategory_DisplayName()), new ChangeRequestSCMHeadCategory(Messages._BitbucketSCMSource_ChangeRequestSCMHeadCategory_DisplayName()), new TagSCMHeadCategory(Messages._BitbucketSCMSource_TagSCMHeadCategory_DisplayName())};
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, BitbucketSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, BitbucketGitSCMBuilder.class));
            HashSet<SCMSourceTraitDescriptor> dedup = new HashSet<SCMSourceTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMSourceTraitDescriptor d = (SCMSourceTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            int insertionPoint = result.size();
            NamedArrayList.select(all, (String)"Git", it -> GitSCM.class.isAssignableFrom(it.getScmClass()), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result, (int)insertionPoint);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks())});
        }
    }

    private static class WrappedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedException(Throwable cause) {
            super(cause);
        }

        public void unwrap() throws IOException, InterruptedException {
            Throwable cause = this.getCause();
            if (cause instanceof IOException) {
                IOException ioEx = (IOException)cause;
                throw ioEx;
            }
            if (cause instanceof InterruptedException) {
                InterruptedException interruptedEx = (InterruptedException)cause;
                throw interruptedEx;
            }
            if (cause instanceof RuntimeException) {
                RuntimeException rtEx = (RuntimeException)cause;
                throw rtEx;
            }
            throw this;
        }
    }

    private static class BitbucketProbeFactory<I>
    implements SCMSourceRequest.ProbeLambda<SCMHead, I> {
        private final BitbucketApi bitbucket;
        private final BitbucketSCMSourceRequest request;

        public BitbucketProbeFactory(BitbucketApi bitbucket, BitbucketSCMSourceRequest request) {
            this.bitbucket = bitbucket;
            this.request = request;
        }

        @NonNull
        public SCMSourceCriteria.Probe create(final @NonNull SCMHead head, final @CheckForNull I revisionInfo) throws IOException, InterruptedException {
            String string;
            if (revisionInfo instanceof BitbucketCommit) {
                BitbucketCommit bbRevision = (BitbucketCommit)revisionInfo;
                string = bbRevision.getHash();
            } else {
                string = (String)revisionInfo;
            }
            final String hash = string;
            return new SCMSourceCriteria.Probe(){
                private static final long serialVersionUID = 1L;

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    try {
                        BitbucketCommit commit = null;
                        if (hash != null) {
                            BitbucketCommit bbRevision;
                            BitbucketCommit bitbucketCommit = commit = revisionInfo instanceof BitbucketCommit ? (bbRevision = (BitbucketCommit)revisionInfo) : bitbucket.resolveCommit(hash);
                        }
                        if (commit == null) {
                            request.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                            return 0L;
                        }
                        return commit.getDateMillis();
                    }
                    catch (IOException | InterruptedException e) {
                        request.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                        return 0L;
                    }
                }

                public boolean exists(@NonNull String path) throws IOException {
                    if (hash == null) {
                        request.listener().getLogger().format("Can not resolve path for hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                        return false;
                    }
                    try {
                        return bitbucket.checkPathExists(hash, path);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }
            };
        }
    }

    private static class CriteriaWitness
    implements SCMSourceRequest.Witness {
        private final BitbucketSCMSourceRequest request;

        public CriteriaWitness(BitbucketSCMSourceRequest request) {
            this.request = request;
        }

        public void record(@NonNull SCMHead scmHead, SCMRevision revision, boolean isMatch) {
            if (revision == null) {
                this.request.listener().getLogger().println("    Skipped");
            } else if (isMatch) {
                this.request.listener().getLogger().println("    Met criteria");
            } else {
                this.request.listener().getLogger().println("    Does not meet criteria");
            }
        }
    }

    private class BitbucketRevisionFactory<I>
    implements SCMSourceRequest.LazyRevisionLambda<SCMHead, SCMRevision, I> {
        private final BitbucketApi client;

        public BitbucketRevisionFactory(BitbucketApi client) {
            this.client = client;
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I input) throws IOException, InterruptedException {
            return this.create(head, input, null);
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I sourceInput, @Nullable I targetInput) throws IOException, InterruptedException {
            BitbucketCommit sourceCommit = this.asCommit(sourceInput);
            BitbucketCommit targetCommit = this.asCommit(targetInput);
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                SCMHead targetHead = prHead.getTarget();
                return new PullRequestSCMRevision(prHead, new BitbucketGitSCMRevision(targetHead, targetCommit), new BitbucketGitSCMRevision(prHead, sourceCommit));
            }
            BitbucketGitSCMRevision revision = new BitbucketGitSCMRevision(head, sourceCommit);
            return revision;
        }

        private BitbucketCommit asCommit(I input) throws IOException, InterruptedException {
            if (input instanceof String) {
                String value = (String)input;
                return this.client.resolveCommit(value);
            }
            if (input instanceof BitbucketCommit) {
                BitbucketCommit commit = (BitbucketCommit)input;
                return commit;
            }
            return null;
        }
    }

    private static class BranchHeadCommit
    implements BitbucketCommit {
        private final BitbucketBranch branch;

        public BranchHeadCommit(@NonNull BitbucketBranch branch) {
            this.branch = branch;
        }

        @Override
        public String getAuthor() {
            return this.branch.getAuthor();
        }

        @Override
        public String getMessage() {
            return this.branch.getMessage();
        }

        @Override
        public String getDate() {
            return new StdDateFormat().format(new Date(this.branch.getDateMillis()));
        }

        @Override
        public String getHash() {
            return this.branch.getRawNode();
        }

        @Override
        public long getDateMillis() {
            return this.branch.getDateMillis();
        }
    }
}

