/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.avatars;

import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.UrlAvatarCacheSource;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.util.DaemonThreadFactory;
import hudson.util.HttpResponses;
import hudson.util.NamingThreadFactory;
import jakarta.servlet.ServletException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class AvatarCache
implements UnprotectedRootAction {
    private static final String ActionURI = "custom-avatar-cache";
    private static final int CONCURRENT_REQUEST_LIMIT = 4;
    private final ConcurrentMap<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final ThreadPoolExecutor service = new ThreadPoolExecutor(4, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), this.getClass().getName()));
    private final Object serviceLock = new Object();
    private Iterator<Map.Entry<String, CacheEntry>> iterator = null;
    private final long startedTime;

    public AvatarCache() {
        this.service.allowCoreThreadTimeOut(true);
        this.startedTime = System.currentTimeMillis() / 1000L * 1000L;
    }

    public static String buildUrl(@NonNull String url, @NonNull String size) {
        return AvatarCache.buildUrl(new UrlAvatarCacheSource(url), size);
    }

    public static String buildUrl(@NonNull AvatarCacheSource source, @NonNull String size) {
        Jenkins j = Jenkins.get();
        AvatarCache instance = (AvatarCache)ExtensionList.lookup(RootAction.class).get(AvatarCache.class);
        if (instance == null) {
            throw new AssertionError();
        }
        String key = Util.getDigestOf((String)(AvatarCache.class.getName() + source.hashKey()));
        instance.getCacheEntry(key, source);
        try {
            return j.getRootUrlFromRequest() + instance.getUrlName() + "/" + Util.rawEncode((String)key) + ".png?size=" + URLEncoder.encode(size, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("JLS specification mandates support for UTF-8 encoding", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static BufferedImage scaleImage(@NonNull BufferedImage src, int size) {
        int newHeight;
        int newWidth;
        BufferedImage imageSrc = src;
        if (src.getWidth() > src.getHeight()) {
            newWidth = size;
            newHeight = size * src.getHeight() / src.getWidth();
        } else if (src.getHeight() > src.getWidth()) {
            newWidth = size * src.getWidth() / src.getHeight();
            newHeight = size;
        } else {
            newWidth = newHeight = size;
        }
        boolean flushSrc = false;
        if (newWidth <= src.getWidth() * 6 / 7 && newHeight <= src.getWidth() * 6 / 7) {
            int curWidth = src.getWidth();
            int curHeight = src.getHeight();
            int penultimateSize = size * 7 / 6;
            while (true) {
                curWidth -= curWidth / 7;
                curHeight -= curHeight / 7;
                if (curWidth <= penultimateSize && curHeight <= penultimateSize) break;
                BufferedImage tmp = new BufferedImage(curWidth, curHeight, 2);
                Graphics2D g = tmp.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    g.scale((double)curWidth / (double)src.getWidth(), (double)curHeight / (double)src.getHeight());
                    g.drawImage((Image)src, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
                if (flushSrc) {
                    imageSrc.flush();
                }
                imageSrc = tmp;
                flushSrc = true;
            }
        }
        BufferedImage tmp = new BufferedImage(size, size, 2);
        Graphics2D g = tmp.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g.scale((double)newWidth / (double)imageSrc.getWidth(), (double)newHeight / (double)imageSrc.getHeight());
            g.drawImage((Image)imageSrc, (size - newWidth) / 2, (size - newHeight) / 2, null);
        }
        finally {
            g.dispose();
        }
        if (flushSrc) {
            imageSrc.flush();
        }
        imageSrc = tmp;
        return imageSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage generateAvatar(@NonNull String seed, int size) {
        byte[] bytes;
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            bytes = d.digest(seed.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("JLS specification mandates support for MD5 message digest", e);
        }
        BufferedImage canvas = new BufferedImage(size, size, 2);
        Graphics2D g = canvas.createGraphics();
        try {
            g.setColor(new Color(bytes[0] & 0xEF, bytes[1] & 0xEF, bytes[2] & 0xEF));
            int pSize = size / 5;
            int pOffset = (size - pSize * 5) / 2;
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 5; ++x) {
                    byte bit = (byte)(1 << Math.min(x, 4 - x));
                    if ((bytes[3 + y] & bit) == 0) continue;
                    g.fillRect(pOffset + x * pSize, pOffset + y * pSize, pSize, pSize);
                }
            }
        }
        finally {
            g.dispose();
        }
        return canvas;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return ActionURI;
    }

    public HttpResponse doDynamic(StaplerRequest2 req, @QueryParameter String requestedSize) {
        if (StringUtils.isBlank((String)req.getRestOfPath())) {
            return HttpResponses.notFound();
        }
        String key = req.getRestOfPath().substring(1);
        if (!key.endsWith(".png")) {
            return HttpResponses.notFound();
        }
        key = StringUtils.removeEnd((String)key, (String)".png");
        String size = StringUtils.defaultIfBlank((String)requestedSize, (String)"48x48");
        int targetSize = 48;
        int index = size.toLowerCase(Locale.ENGLISH).indexOf(120);
        if (index < 2) {
            try {
                targetSize = Math.min(128, Math.max(16, Integer.parseInt(StringUtils.trim((String)size))));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                targetSize = Math.min(128, Math.max(16, Integer.parseInt(StringUtils.trim((String)size.substring(0, index)))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        final CacheEntry avatar = this.getCacheEntry(key, null);
        long since = req.getDateHeader("If-Modified-Since");
        if (avatar == null || !avatar.canFetch()) {
            if (this.startedTime <= since) {
                return new HttpResponse(){

                    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                        rsp.addDateHeader("Last-Modified", AvatarCache.this.startedTime);
                        rsp.addHeader("Cache-control", "max-age=365000000, immutable, public");
                        rsp.setStatus(304);
                    }
                };
            }
            return new ImageResponse(AvatarCache.generateAvatar(avatar == null ? "" : avatar.source.hashKey(), targetSize), true, this.startedTime, "max-age=365000000, immutable, public");
        }
        if (avatar.pending() && avatar.image == null) {
            return new ImageResponse(AvatarCache.generateAvatar(avatar.source.hashKey(), targetSize), true, -1L, "no-cache, public");
        }
        if (avatar.lastModified <= since) {
            return new HttpResponse(){

                public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                    rsp.addDateHeader("Last-Modified", avatar.lastModified);
                    rsp.addHeader("Cache-control", "max-age=3600, public");
                    rsp.setStatus(304);
                }
            };
        }
        if (avatar.image == null) {
            return new ImageResponse(AvatarCache.generateAvatar(avatar.source.hashKey(), targetSize), true, -1L, "max-age=3600, public");
        }
        BufferedImage image = avatar.image;
        boolean flushImage = false;
        if (image.getWidth() != targetSize || image.getHeight() != targetSize) {
            image = AvatarCache.scaleImage(image, targetSize);
            flushImage = true;
        }
        return new ImageResponse(image, flushImage, avatar.lastModified, "max-age=3600, public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CacheEntry getCacheEntry(@NonNull String key, @Nullable AvatarCacheSource source) {
        Iterator<Map.Entry<String, CacheEntry>> iterator;
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                entry = (CacheEntry)this.cache.get(key);
                if (entry == null) {
                    if (source == null) {
                        return null;
                    }
                    entry = new CacheEntry(source, this.service.submit(new FetchImage(source)));
                    this.cache.put(key, entry);
                }
            }
        }
        if (entry.isStale()) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                if (!entry.pending()) {
                    entry.setFuture(this.service.submit(new FetchImage(entry.source)));
                }
            }
        }
        entry.touch();
        if (this.iterator == null || !this.iterator.hasNext()) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    this.iterator = this.cache.entrySet().iterator();
                }
            }
        }
        iterator = this.iterator;
        synchronized (iterator) {
            if (this.iterator.hasNext()) {
                Map.Entry<String, CacheEntry> next = this.iterator.next();
                if (next.getValue().isUnused()) {
                    this.iterator.remove();
                }
            } else {
                this.iterator = null;
            }
        }
        return entry;
    }

    private static class CacheEntry {
        private final AvatarCacheSource source;
        @CheckForNull
        private BufferedImage image;
        private long lastModified;
        private long lastAccessed = -1L;
        private Future<CacheEntry> future;

        private CacheEntry(AvatarCacheSource source, BufferedImage image, long lastModified) {
            this.source = source;
            if (image.getHeight() > 128 || image.getWidth() > 128) {
                this.image = AvatarCache.scaleImage(image, 128);
                image.flush();
            } else {
                this.image = image;
            }
            this.lastModified = lastModified < 0L ? System.currentTimeMillis() : lastModified;
        }

        public boolean canFetch() {
            return this.source != null && this.source.canFetch();
        }

        private CacheEntry(AvatarCacheSource source, Future<CacheEntry> future) {
            this.source = source;
            this.image = null;
            this.lastModified = System.currentTimeMillis();
            this.future = future;
        }

        private CacheEntry(AvatarCacheSource source) {
            this.source = source;
            this.lastModified = System.currentTimeMillis();
        }

        private synchronized boolean pending() {
            if (this.future == null) {
                return false;
            }
            if (this.future.isDone()) {
                try {
                    CacheEntry pending = this.future.get();
                    if (pending.image != null && this.image != null) {
                        this.image.flush();
                    }
                    if (pending.image != null) {
                        this.image = pending.image;
                    }
                    this.lastModified = pending.lastModified;
                    this.future = null;
                    return false;
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
            return true;
        }

        private synchronized void setFuture(Future<CacheEntry> future) {
            this.future = future;
        }

        private synchronized boolean isStale() {
            return System.currentTimeMillis() - this.lastModified > TimeUnit.MINUTES.toMillis(Long.getLong(AvatarCache.class.getName() + ".stale.ttl", 60L));
        }

        private void touch() {
            this.lastAccessed = System.currentTimeMillis();
        }

        private boolean isUnused() {
            return this.lastAccessed > 0L && System.currentTimeMillis() - this.lastAccessed > TimeUnit.MINUTES.toMillis(Long.getLong(AvatarCache.class.getName() + ".unused.ttl", 60L));
        }
    }

    private static class ImageResponse
    implements HttpResponse {
        private final BufferedImage image;
        private final boolean flushImage;
        private final String cacheControl;
        private final long lastModified;

        private ImageResponse(BufferedImage image, boolean flushImage, long lastModified, String cacheControl) {
            this.cacheControl = cacheControl;
            this.image = image;
            this.flushImage = flushImage;
            this.lastModified = lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.image, "png", bos);
            }
            finally {
                if (this.flushImage) {
                    this.image.flush();
                }
            }
            byte[] bytes = bos.toByteArray();
            if (this.lastModified > 0L) {
                rsp.addDateHeader("Last-Modified", this.lastModified);
            }
            rsp.addHeader("Cache-control", this.cacheControl);
            rsp.setContentType("image/png");
            rsp.setContentLength(bytes.length);
            rsp.getOutputStream().write(bytes);
        }
    }

    private static class FetchImage
    implements Callable<CacheEntry> {
        private final AvatarCacheSource source;

        private FetchImage(@NonNull AvatarCacheSource source) {
            this.source = source;
        }

        @Override
        public CacheEntry call() throws Exception {
            AvatarCacheSource.AvatarImage image = this.source.fetch();
            if (image == null) {
                return new CacheEntry(this.source);
            }
            return new CacheEntry(this.source, image.image, image.lastModified);
        }
    }
}

