/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCloudWorkspace;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudPage;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.client.ClosingConnectionInputStream;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestCommits;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestValue;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHook;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHooks;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositorySource;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.PaginatedBitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.AbstractBitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUsernamePasswordAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.impl.Operator;
import com.fasterxml.jackson.core.type.TypeReference;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jenkins.scm.api.SCMFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;

public class BitbucketCloudApiClient
extends AbstractBitbucketApi
implements BitbucketApi {
    private static final HttpHost API_HOST = HttpHost.create((String)"https://api.bitbucket.org");
    private static final String V2_API_BASE_URL = "https://api.bitbucket.org/2.0/repositories";
    private static final String V2_WORKSPACES_API_BASE_URL = "https://api.bitbucket.org/2.0/workspaces";
    private static final String REPO_URL_TEMPLATE = "https://api.bitbucket.org/2.0/repositories{/owner,repo}";
    private static final int MAX_AVATAR_LENGTH = 16384;
    private static final int MAX_PAGE_LENGTH = 100;
    private static final HttpClientConnectionManager connectionManager = BitbucketCloudApiClient.getConnectionManager();
    private CloseableHttpClient client;
    private final String owner;
    private final String projectKey;
    private final String repositoryName;
    private final boolean enableCache;
    private final BitbucketAuthenticator authenticator;
    private static final Cache<String, BitbucketTeam> cachedTeam = new Cache(6, TimeUnit.HOURS);
    private static final Cache<String, AvatarCacheSource.AvatarImage> cachedAvatar = new Cache(6, TimeUnit.HOURS);
    private static final Cache<String, List<BitbucketCloudRepository>> cachedRepositories = new Cache(3, TimeUnit.HOURS);
    private static final Cache<String, BitbucketCloudCommit> cachedCommits = new Cache(24, TimeUnit.HOURS);
    private transient BitbucketRepository cachedRepository;
    private transient String cachedDefaultBranch;

    private static HttpClientConnectionManager getConnectionManager() {
        try {
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            connManager.setDefaultMaxPerRoute(20);
            connManager.setMaxTotal(22);
            connManager.setSocketConfig(API_HOST, SocketConfig.custom().setSoTimeout(60000).build());
            return connManager;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> stats() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Team: " + cachedTeam.stats().toString());
        stats.add("Repositories : " + cachedRepositories.stats().toString());
        stats.add("Commits: " + cachedCommits.stats().toString());
        return stats;
    }

    public static void clearCaches() {
        cachedTeam.evictAll();
        cachedRepositories.evictAll();
        cachedCommits.evictAll();
    }

    @Deprecated
    public BitbucketCloudApiClient(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, String owner, String repositoryName, StandardUsernamePasswordCredentials credentials) {
        this(enableCache, teamCacheDuration, repositoriesCacheDuration, owner, null, repositoryName, new BitbucketUsernamePasswordAuthenticator(credentials));
    }

    public BitbucketCloudApiClient(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, String owner, String projectKey, String repositoryName, BitbucketAuthenticator authenticator) {
        this.authenticator = authenticator;
        this.owner = owner;
        this.projectKey = projectKey;
        this.repositoryName = repositoryName;
        this.enableCache = enableCache;
        if (enableCache) {
            cachedTeam.setExpireDuration(teamCacheDuration, TimeUnit.MINUTES);
            cachedRepositories.setExpireDuration(repositoriesCacheDuration, TimeUnit.MINUTES);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager(connectionManager).setConnectionManagerShared(connectionManager != null).setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler());
        if (authenticator != null) {
            authenticator.configureBuilder(httpClientBuilder);
            this.context = HttpClientContext.create();
            authenticator.configureContext(this.context, API_HOST);
        }
        this.setClientProxyParams("bitbucket.org", httpClientBuilder);
        this.client = httpClientBuilder.build();
    }

    protected void finalize() throws Throwable {
        if (this.client != null) {
            this.client.close();
        }
        super.finalize();
    }

    @Override
    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @CheckForNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @NonNull
    public List<BitbucketPullRequestValue> getPullRequests() throws InterruptedException, IOException {
        BitbucketPullRequests page;
        ArrayList<BitbucketPullRequestValue> pullRequests = new ArrayList<BitbucketPullRequestValue>();
        int pageLen = 50;
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)pageLen);
        int pageNumber = 1;
        do {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String url = template.set("page", (Object)pageNumber++).expand();
            String response = this.getRequest(url);
            try {
                page = JsonParser.toJava(response, BitbucketPullRequests.class);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
            pullRequests.addAll(page.getValues());
        } while (page.getNext() != null);
        pullRequests.removeIf(this::shouldIgnore);
        for (BitbucketPullRequestValue pullRequest : pullRequests) {
            this.setupClosureForPRBranch(pullRequest);
        }
        return pullRequests;
    }

    private boolean shouldIgnore(BitbucketPullRequest pr) {
        return pr.getSource().getRepository() == null || pr.getSource().getCommit() == null || pr.getDestination().getBranch() == null || pr.getDestination().getCommit() == null;
    }

    private void setupClosureForPRBranch(BitbucketPullRequestValue pullRequest) {
        BitbucketCloudBranch branch = pullRequest.getSource().getBranch();
        if (branch != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
        if ((branch = pullRequest.getDestination().getBranch()) != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
    }

    @Deprecated
    @CheckForNull
    public String getLogin() {
        if (this.authenticator != null) {
            return this.authenticator.getId();
        }
        return null;
    }

    @Override
    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer id) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{/id}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        String response = this.getRequest(url);
        try {
            BitbucketPullRequestValue pr = JsonParser.toJava(response, BitbucketPullRequestValue.class);
            this.setupClosureForPRBranch(pr);
            return pr;
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public BitbucketRepository getRepository() throws IOException, InterruptedException {
        if (this.repositoryName == null) {
            throw new UnsupportedOperationException("Cannot get a repository from an API instance that is not associated with a repository");
        }
        if (!this.enableCache || this.cachedRepository == null) {
            String url = UriTemplate.fromTemplate((String)REPO_URL_TEMPLATE).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
            String response = this.getRequest(url);
            try {
                this.cachedRepository = JsonParser.toJava(response, BitbucketCloudRepository.class);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        }
        return this.cachedRepository;
    }

    @Override
    public void postCommitComment(@NonNull String hash, @NonNull String comment) throws IOException, InterruptedException {
        String path = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit{/hash}/build").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        try {
            this.postRequest(path, Collections.singletonList(new BasicNameValuePair("content", comment)));
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Cannot comment on commit, url: " + path, e);
        }
    }

    @Override
    public boolean checkPathExists(@NonNull String branchOrHash, @NonNull String path) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path*}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)branchOrHash).set("path", (Object)path.split(Operator.PATH.getSeparator())).expand();
        int status = this.headRequestStatus(url);
        if (200 == status) {
            return true;
        }
        if (404 == status) {
            return false;
        }
        if (403 == status) {
            this.logger.log(Level.FINE, "You currently do not have permissions to pull from repo: {0} at branch {1}", new Object[]{this.repositoryName, branchOrHash});
            return false;
        }
        throw new IOException("Communication error for url: " + path + " status code: " + status);
    }

    @Override
    @CheckForNull
    public String getDefaultBranch() throws IOException, InterruptedException {
        if (!this.enableCache || this.cachedDefaultBranch == null) {
            String response;
            String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/{?fields}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("fields", (Object)"mainbranch.name").expand();
            try {
                response = this.getRequest(url);
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.FINE, "Could not find default branch for {0}/{1}", new Object[]{this.owner, this.repositoryName});
                return null;
            }
            Map resp = JsonParser.toJava(response, Map.class);
            Map mainbranch = (Map)resp.get("mainbranch");
            if (mainbranch != null) {
                this.cachedDefaultBranch = (String)mainbranch.get("name");
            }
        }
        return this.cachedDefaultBranch;
    }

    @Override
    public BitbucketCloudBranch getTag(@NonNull String tagName) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/refs/tags/{name}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("name", (Object)tagName).expand();
        String response = this.getRequest(url);
        try {
            return this.getSingleBranch(response);
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @NonNull
    public List<BitbucketCloudBranch> getTags() throws IOException, InterruptedException {
        return this.getBranchesByRef("/refs/tags");
    }

    @Override
    public BitbucketCloudBranch getBranch(@NonNull String branchName) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/refs/branches/{name}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("name", (Object)branchName).expand();
        String response = this.getRequest(url);
        try {
            return this.getSingleBranch(response);
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @NonNull
    public List<BitbucketCloudBranch> getBranches() throws IOException, InterruptedException {
        return this.getBranchesByRef("/refs/branches");
    }

    public List<BitbucketCloudBranch> getBranchesByRef(String nodePath) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)(REPO_URL_TEMPLATE + nodePath + "{?pagelen}")).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)100).expand();
        String response = this.getRequest(url);
        try {
            return this.getAllBranches(response);
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    @CheckForNull
    public BitbucketCommit resolveCommit(@NonNull String hash) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit/{hash}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        Callable<BitbucketCloudCommit> request = () -> {
            String response;
            try {
                response = this.getRequest(url);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            try {
                return JsonParser.toJava(response, BitbucketCloudCommit.class);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        };
        try {
            if (this.enableCache) {
                return cachedCommits.get(hash, request);
            }
            return request.call();
        }
        catch (IOException | InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest pull) throws IOException, InterruptedException {
        return this.resolveCommit(pull).getHash();
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest pull) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests/{pullId}/commits{?fields,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pullId", (Object)pull.getId()).set("fields", (Object)"values.hash,values.author.raw,values.date,values.message").set("pagelen", (Object)1).expand();
        String response = this.getRequest(url);
        try {
            BitbucketPullRequestCommits commits = JsonParser.toJava(response, BitbucketPullRequestCommits.class);
            return (BitbucketCommit)Util.fixNull(commits.getValues()).stream().findFirst().orElseThrow(() -> new BitbucketException("Could not determine commit for pull request " + pull.getId()));
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    public void registerCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
        this.postRequest(url, JsonParser.toJson(hook));
    }

    @Override
    public void updateCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{hook}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hook", (Object)hook.getUuid()).expand();
        this.putRequest(url, JsonParser.toJson(hook));
    }

    @Override
    public void removeCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)hook.getUuid())) {
            throw new BitbucketException("Hook UUID required");
        }
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{uuid}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("uuid", (Object)hook.getUuid()).expand();
        this.deleteRequest(url);
    }

    @NonNull
    public List<BitbucketRepositoryHook> getWebHooks() throws IOException, InterruptedException {
        ArrayList<BitbucketRepositoryHook> repositoryHooks = new ArrayList<BitbucketRepositoryHook>();
        int pageNumber = 1;
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("page", (Object)pageNumber).set("pagelen", (Object)100);
        String url = template.expand();
        try {
            String response = this.getRequest(url);
            BitbucketRepositoryHooks page = this.parsePaginatedRepositoryHooks(response);
            repositoryHooks.addAll(page.getValues());
            while (page.getNext() != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                url = template.set("page", (Object)(++pageNumber)).expand();
                response = this.getRequest(url);
                page = this.parsePaginatedRepositoryHooks(response);
                repositoryHooks.addAll(page.getValues());
            }
            return repositoryHooks;
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    public void postBuildStatus(@NonNull BitbucketBuildStatus status) throws IOException, InterruptedException {
        BitbucketBuildStatus newStatus = new BitbucketBuildStatus(status);
        newStatus.setName(this.truncateMiddle(newStatus.getName(), 255));
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit/{hash}/statuses/build").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)newStatus.getHash()).expand();
        this.postRequest(url, JsonParser.toJson(newStatus));
    }

    @Override
    public boolean isPrivate() throws IOException, InterruptedException {
        return this.getRepository().isPrivate();
    }

    private BitbucketRepositoryHooks parsePaginatedRepositoryHooks(String response) throws IOException {
        BitbucketRepositoryHooks parsedResponse = JsonParser.toJava(response, BitbucketRepositoryHooks.class);
        return parsedResponse;
    }

    @Override
    @CheckForNull
    public BitbucketTeam getTeam() throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/workspaces{/owner}").set("owner", (Object)this.owner).expand();
        Callable<BitbucketTeam> request = () -> {
            try {
                String response = this.getRequest(url);
                return JsonParser.toJava(response, BitbucketCloudWorkspace.class);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        };
        try {
            if (this.enableCache) {
                return cachedTeam.get(this.owner, request);
            }
            return request.call();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    @CheckForNull
    public AvatarCacheSource.AvatarImage getTeamAvatar() throws IOException, InterruptedException {
        String url;
        BitbucketTeam team = this.getTeam();
        String string = url = team != null ? team.getLink("avatar") : null;
        if (url == null) {
            return AvatarCacheSource.AvatarImage.EMPTY;
        }
        Callable<AvatarCacheSource.AvatarImage> request = () -> {
            try {
                BufferedImage avatar = this.getImageRequest(url);
                return new AvatarCacheSource.AvatarImage(avatar, System.currentTimeMillis());
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.FINE, "Failed to get avatar for team {0} from URL: " + url, team.getName());
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
            return null;
        };
        try {
            if (this.enableCache) {
                return cachedAvatar.get(this.owner, request);
            }
            return request.call();
        }
        catch (Exception ex) {
            try {
                return null;
            }
            catch (Exception ex2) {
                this.logger.log(Level.FINE, "Unexpected exception while loading team avatar: " + ex2.getMessage(), ex2);
                throw ex2;
            }
        }
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories(@CheckForNull UserRoleInRepository role) throws InterruptedException, IOException {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(this.owner);
        if (this.authenticator != null) {
            cacheKey.append("::").append(this.authenticator.getId());
        } else {
            cacheKey.append("::<anonymous>");
        }
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner}{?role,page,pagelen,q}").set("owner", (Object)this.owner).set("pagelen", (Object)100);
        if (StringUtils.isNotBlank((String)this.projectKey)) {
            template.set("q", (Object)("project.key=\"" + this.projectKey + "\""));
            cacheKey.append("::").append(this.projectKey);
        } else {
            cacheKey.append("::<undefined>");
        }
        if (role != null && this.authenticator != null) {
            template.set("role", (Object)role.getId());
            cacheKey.append("::").append(role.getId());
        } else {
            cacheKey.append("::<undefined>");
        }
        Callable<List> request = () -> {
            PaginatedBitbucketRepository page;
            ArrayList<BitbucketCloudRepository> repositories = new ArrayList<BitbucketCloudRepository>();
            Integer pageNumber = 1;
            do {
                String url = template.set("page", (Object)pageNumber).expand();
                String response = this.getRequest(url);
                try {
                    page = JsonParser.toJava(response, PaginatedBitbucketRepository.class);
                    repositories.addAll(page.getValues());
                }
                catch (IOException e) {
                    throw new IOException("I/O error when parsing response from URL: " + url, e);
                }
                Integer n = pageNumber;
                pageNumber = pageNumber + 1;
            } while (page.getNext() != null);
            repositories.sort(Comparator.comparing(BitbucketCloudRepository::getRepositoryName));
            return repositories;
        };
        try {
            if (this.enableCache) {
                return cachedRepositories.get(cacheKey.toString(), request);
            }
            return request.call();
        }
        catch (Exception ex) {
            throw new IOException("Error while loading repositories from cache", ex);
        }
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories() throws IOException, InterruptedException {
        return this.getRepositories(null);
    }

    @Restricted(value={ProtectedExternally.class})
    protected CloseableHttpResponse executeMethod(HttpRequestBase httpMethod) throws InterruptedException, IOException {
        return this.executeMethod(API_HOST, httpMethod);
    }

    @Restricted(value={ProtectedExternally.class})
    protected CloseableHttpResponse executeMethod(HttpHost host, HttpRequestBase httpMethod) throws InterruptedException, IOException {
        HttpClientContext requestContext = null;
        if (API_HOST.equals((Object)host)) {
            requestContext = this.context;
            if (this.authenticator != null) {
                this.authenticator.configureRequest((HttpRequest)httpMethod);
            }
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        String connectTimeout = System.getProperty("http.connect.timeout", "10");
        requestConfig.setConnectTimeout(Integer.parseInt(connectTimeout) * 1000);
        String connectionRequestTimeout = System.getProperty("http.connect.request.timeout", "60");
        requestConfig.setConnectionRequestTimeout(Integer.parseInt(connectionRequestTimeout) * 1000);
        String socketTimeout = System.getProperty("http.socket.timeout", "60");
        requestConfig.setSocketTimeout(Integer.parseInt(socketTimeout) * 1000);
        httpMethod.setConfig(requestConfig.build());
        CloseableHttpResponse response = this.client.execute(host, (HttpRequest)httpMethod, (HttpContext)requestContext);
        while (response.getStatusLine().getStatusCode() == 429) {
            this.release(httpMethod);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.logger.fine("Bitbucket Cloud API rate limit reached, sleeping for 5 sec then retry...");
            Thread.sleep(5000L);
            response = this.client.execute(host, (HttpRequest)httpMethod, (HttpContext)requestContext);
        }
        return response;
    }

    private InputStream getRequestAsInputStream(String path) throws IOException, InterruptedException {
        HttpGet httpget = new HttpGet(path);
        HttpHost host = null;
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute() && !uri.isOpaque()) {
                host = HttpHost.create((String)(uri.getScheme() + "://" + uri.getAuthority()));
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (host == null) {
            host = API_HOST;
        }
        try {
            CloseableHttpResponse response = this.executeMethod(host, (HttpRequestBase)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
                throw new FileNotFoundException("URL: " + path);
            }
            if (statusCode != 200) {
                String content = this.getResponseContent(response);
                throw this.buildResponseException(response, content);
            }
            return new ClosingConnectionInputStream(response, (HttpRequestBase)httpget, connectionManager);
        }
        catch (BitbucketRequestException | FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Communication error for url: " + path, e);
        }
    }

    private String getRequest(String path) throws IOException, InterruptedException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private BufferedImage getImageRequest(String path) throws IOException, InterruptedException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            int length = 16384;
            BufferedInputStream bis = new BufferedInputStream(inputStream, length);
            BufferedImage bufferedImage = ImageIO.read(bis);
            return bufferedImage;
        }
    }

    private int headRequestStatus(String path) throws IOException, InterruptedException {
        HttpHead httpHead = new HttpHead(path);
        try {
            int n;
            block11: {
                CloseableHttpResponse response = this.executeMethod((HttpRequestBase)httpHead);
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    n = response.getStatusLine().getStatusCode();
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOException("Communication error for url: " + path, e);
                    }
                }
                response.close();
            }
            return n;
        }
        finally {
            this.release((HttpRequestBase)httpHead);
        }
    }

    private void deleteRequest(String path) throws IOException, InterruptedException {
        HttpDelete httppost = new HttpDelete(path);
        try (CloseableHttpResponse response = this.executeMethod((HttpRequestBase)httppost);){
            EntityUtils.consume((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new FileNotFoundException("URL: " + path);
            }
            if (statusCode != 204) {
                throw this.buildResponseException(response, this.getResponseContent(response));
            }
        }
        catch (BitbucketRequestException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Communication error for url: " + path, e);
        }
        finally {
            this.release((HttpRequestBase)httppost);
        }
    }

    private String doRequest(HttpRequestBase request) throws IOException, InterruptedException {
        try {
            String string;
            block17: {
                int statusCode;
                CloseableHttpResponse response;
                block15: {
                    String string2;
                    block16: {
                        response = this.executeMethod(request);
                        try {
                            statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode != 204) break block15;
                            EntityUtils.consume((HttpEntity)response.getEntity());
                            string2 = "";
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (response != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (BitbucketRequestException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw new IOException("Communication error for url: " + request, e);
                            }
                        }
                        response.close();
                    }
                    return string2;
                }
                String content = this.getResponseContent(response);
                EntityUtils.consume((HttpEntity)response.getEntity());
                if (statusCode != 200 && statusCode != 201) {
                    throw this.buildResponseException(response, content);
                }
                string = content;
                if (response == null) break block17;
                response.close();
            }
            return string;
        }
        finally {
            this.release(request);
        }
    }

    private void release(HttpRequestBase method) {
        method.releaseConnection();
        connectionManager.closeExpiredConnections();
    }

    private String putRequest(String path, String content) throws IOException, InterruptedException {
        HttpPut request = new HttpPut(path);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpRequestBase)request);
    }

    private String postRequest(String path, String content) throws IOException, InterruptedException {
        HttpPost httppost = new HttpPost(path);
        httppost.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpRequestBase)httppost);
    }

    private String postRequest(String path, List<? extends NameValuePair> params) throws IOException, InterruptedException {
        HttpPost httppost = new HttpPost(path);
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.doRequest((HttpRequestBase)httppost);
    }

    private List<BitbucketCloudBranch> getAllBranches(String response) throws IOException, InterruptedException {
        ArrayList branches = new ArrayList();
        BitbucketCloudPage page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketCloudBranch>>(){});
        branches.addAll(page.getValues());
        while (!page.isLastPage()) {
            response = this.getRequest(page.getNext());
            page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketCloudBranch>>(){});
            branches.addAll(page.getValues());
        }
        ArrayList<BitbucketCloudBranch> activeBranches = new ArrayList<BitbucketCloudBranch>();
        for (BitbucketCloudBranch branch : branches) {
            if (!branch.isActive()) continue;
            activeBranches.add(branch);
        }
        return activeBranches;
    }

    private BitbucketCloudBranch getSingleBranch(String response) throws IOException {
        return (BitbucketCloudBranch)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudBranch>(){});
    }

    @Override
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile parent) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)parent.getHash()).set("path", (Object)parent.getPath()).expand();
        ArrayList<SCMFile> result = new ArrayList<SCMFile>();
        String response = this.getRequest(url);
        BitbucketCloudPage page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketRepositorySource>>(){});
        for (BitbucketRepositorySource source : page.getValues()) {
            result.add(source.toBitbucketScmFile(parent));
        }
        while (!page.isLastPage()) {
            response = this.getRequest(page.getNext());
            page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketRepositorySource>>(){});
            for (BitbucketRepositorySource source : page.getValues()) {
                result.add(source.toBitbucketScmFile(parent));
            }
        }
        return result;
    }

    @Override
    public InputStream getFileContent(BitbucketSCMFile file) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)file.getHash()).set("path", (Object)file.getPath()).expand();
        return this.getRequestAsInputStream(url);
    }

    private class CommitClosure
    implements Callable<BitbucketCommit> {
        private final String hash;

        public CommitClosure(String hash) {
            this.hash = hash;
        }

        @Override
        public BitbucketCommit call() throws Exception {
            return BitbucketCloudApiClient.this.resolveCommit(this.hash);
        }
    }
}

