/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketEndpointConfiguration
extends GlobalConfiguration {
    private List<AbstractBitbucketEndpoint> endpoints;

    public BitbucketEndpointConfiguration() {
        this.load();
    }

    public static BitbucketEndpointConfiguration get() {
        return (BitbucketEndpointConfiguration)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(BitbucketEndpointConfiguration.class));
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String readResolveServerUrl(@CheckForNull String bitbucketServerUrl) {
        String serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(bitbucketServerUrl);
        AbstractBitbucketEndpoint endpoint = this.findEndpoint(serverUrl);
        if (endpoint == null && ACL.SYSTEM.equals(Jenkins.getAuthentication())) {
            if ("https://bitbucket.org".equals(serverUrl) || "http://bitbucket.org".equals(serverUrl)) {
                this.addEndpoint(new BitbucketCloudEndpoint(false, null));
            } else {
                this.addEndpoint(new BitbucketServerEndpoint(null, serverUrl, false, null));
            }
        }
        return endpoint == null ? serverUrl : endpoint.getServerUrl();
    }

    public boolean isEndpointSelectable() {
        return this.getEndpoints().size() > 1;
    }

    public ListBoxModel getEndpointItems() {
        ListBoxModel result = new ListBoxModel();
        for (AbstractBitbucketEndpoint endpoint : this.getEndpoints()) {
            String serverUrl = endpoint.getServerUrl();
            String displayName = endpoint.getDisplayName();
            result.add((String)(StringUtils.isBlank((String)displayName) ? serverUrl : displayName + " (" + serverUrl + ")"), serverUrl);
        }
        return result;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @NonNull
    public synchronized List<AbstractBitbucketEndpoint> getEndpoints() {
        return this.endpoints == null || this.endpoints.isEmpty() ? Collections.singletonList(new BitbucketCloudEndpoint(false, null)) : Collections.unmodifiableList(this.endpoints);
    }

    public synchronized void setEndpoints(@CheckForNull List<? extends AbstractBitbucketEndpoint> endpoints) {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        ArrayList<AbstractBitbucketEndpoint> eps = new ArrayList<AbstractBitbucketEndpoint>(Util.fixNull(endpoints));
        HashSet<String> serverUrls = new HashSet<String>();
        ListIterator<BitbucketCloudEndpoint> iterator = eps.listIterator();
        while (iterator.hasNext()) {
            AbstractBitbucketEndpoint endpoint = (AbstractBitbucketEndpoint)((Object)iterator.next());
            String serverUrl = endpoint.getServerUrl();
            if (StringUtils.isBlank((String)serverUrl) || serverUrls.contains(serverUrl)) {
                iterator.remove();
                continue;
            }
            if (!(endpoint instanceof BitbucketCloudEndpoint) && "https://bitbucket.org".equals(serverUrl)) {
                iterator.set(new BitbucketCloudEndpoint(endpoint.isManageHooks(), endpoint.getCredentialsId(), endpoint.getBitbucketJenkinsRootUrl()));
            }
            serverUrls.add(serverUrl);
        }
        if (eps.isEmpty()) {
            eps.add(new BitbucketCloudEndpoint(false, null));
        }
        this.endpoints = eps;
        this.save();
    }

    public synchronized boolean addEndpoint(@NonNull AbstractBitbucketEndpoint endpoint) {
        ArrayList<AbstractBitbucketEndpoint> endpoints = new ArrayList<AbstractBitbucketEndpoint>(this.getEndpoints());
        for (AbstractBitbucketEndpoint ep : endpoints) {
            if (!ep.getServerUrl().equals(endpoint.getServerUrl())) continue;
            return false;
        }
        endpoints.add(endpoint);
        this.setEndpoints(endpoints);
        return true;
    }

    public synchronized void updateEndpoint(@NonNull AbstractBitbucketEndpoint endpoint) {
        ArrayList<AbstractBitbucketEndpoint> endpoints = new ArrayList<AbstractBitbucketEndpoint>(this.getEndpoints());
        boolean found = false;
        for (int i = 0; i < endpoints.size(); ++i) {
            AbstractBitbucketEndpoint ep = (AbstractBitbucketEndpoint)((Object)endpoints.get(i));
            if (!ep.getServerUrl().equals(endpoint.getServerUrl())) continue;
            endpoints.set(i, endpoint);
            found = true;
            break;
        }
        if (!found) {
            endpoints.add(endpoint);
        }
        this.setEndpoints(endpoints);
    }

    public boolean removeEndpoint(@NonNull AbstractBitbucketEndpoint endpoint) {
        return this.removeEndpoint(endpoint.getServerUrl());
    }

    public synchronized boolean removeEndpoint(@CheckForNull String serverUrl) {
        serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl);
        boolean modified = false;
        ArrayList<AbstractBitbucketEndpoint> endpoints = new ArrayList<AbstractBitbucketEndpoint>(this.getEndpoints());
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            if (!serverUrl.equals(((AbstractBitbucketEndpoint)((Object)iterator.next())).getServerUrl())) continue;
            iterator.remove();
            modified = true;
        }
        this.setEndpoints(endpoints);
        return modified;
    }

    @CheckForNull
    public synchronized AbstractBitbucketEndpoint findEndpoint(@CheckForNull String serverUrl) {
        serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl);
        for (AbstractBitbucketEndpoint endpoint : this.getEndpoints()) {
            if (!serverUrl.equals(endpoint.getServerUrl())) continue;
            return endpoint;
        }
        return null;
    }

    public synchronized Optional<AbstractBitbucketEndpoint> findEndpoint(@CheckForNull String serverUrl, Class<? extends AbstractBitbucketEndpoint> clazz) {
        return this.getEndpoints().stream().filter(clazz::isInstance).filter(endpoint -> BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl).equals(endpoint.getServerUrl())).findFirst();
    }

    @NonNull
    public static String normalizeServerUrl(@CheckForNull String serverUrl) {
        serverUrl = StringUtils.defaultIfBlank((String)serverUrl, (String)"https://bitbucket.org");
        try {
            URI uri = new URI(serverUrl).normalize();
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                String host = uri.getHost() == null ? null : uri.getHost().toLowerCase(Locale.ENGLISH);
                int port = uri.getPort();
                if ("http".equals(scheme) && port == 80) {
                    port = -1;
                } else if ("https".equals(scheme) && port == 443) {
                    port = -1;
                }
                serverUrl = new URI(scheme, uri.getUserInfo(), host, port, uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return serverUrl.replaceAll("/$", "");
    }
}

