/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.filesystem;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import java.io.IOException;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.acegisecurity.Authentication;

public class BitbucketSCMFileSystem
extends SCMFileSystem {
    private final String ref;
    private final BitbucketApi api;

    protected BitbucketSCMFileSystem(BitbucketApi api, String ref, SCMRevision rev) throws IOException {
        super(rev);
        this.ref = ref;
        this.api = api;
    }

    public long lastModified() throws IOException {
        return 0L;
    }

    @NonNull
    public SCMFile getRoot() {
        SCMRevision revision = this.getRevision();
        return new BitbucketSCMFile(this, this.api, this.ref, revision == null ? null : revision.toString());
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof BitbucketSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return false;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return scmSourceDescriptor instanceof BitbucketSCMSource.DescriptorImpl;
        }

        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) {
            return null;
        }

        private static StandardCredentials lookupScanCredentials(@CheckForNull Item context, @CheckForNull String scanCredentialsId, String serverUrl) {
            if (Util.fixEmpty((String)scanCredentialsId) == null) {
                return null;
            }
            return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl))}));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            BitbucketSCMSource src = (BitbucketSCMSource)source;
            String credentialsId = src.getCredentialsId();
            String owner = src.getRepoOwner();
            String repository = src.getRepository();
            String serverUrl = src.getServerUrl();
            StandardCredentials credentials = BuilderImpl.lookupScanCredentials((Item)src.getOwner(), credentialsId, serverUrl);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(serverUrl), (Credentials)credentials);
            BitbucketApi apiClient = BitbucketApiFactory.newInstance(serverUrl, authenticator, owner, null, repository);
            Object ref = null;
            if (head instanceof BranchSCMHead) {
                ref = head.getName();
                return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
            } else if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                if (prHead.getRepository() == null) {
                    return null;
                }
                if (apiClient instanceof BitbucketCloudApiClient) {
                    if (prHead.getCheckoutStrategy() != ChangeRequestCheckoutStrategy.HEAD || !prHead.getRepoOwner().equals(src.getRepoOwner()) || !prHead.getRepository().equals(src.getRepository())) return null;
                    ref = prHead.getOriginName();
                    return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
                } else if (prHead.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.HEAD) {
                    ref = "pull-requests/" + prHead.getId() + "/from";
                    return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
                } else {
                    BitbucketServerEndpoint endpoint;
                    if (prHead.getCheckoutStrategy() != ChangeRequestCheckoutStrategy.MERGE) return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
                    AbstractBitbucketEndpoint endpointConfig = BitbucketEndpointConfiguration.get().findEndpoint(src.getServerUrl());
                    if (!(endpointConfig instanceof BitbucketServerEndpoint) || (endpoint = (BitbucketServerEndpoint)endpointConfig).getServerVersion() == BitbucketServerVersion.VERSION_7) return null;
                    ref = "pull-requests/" + prHead.getId() + "/merge";
                }
                return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
            } else {
                if (!(head instanceof BitbucketTagSCMHead)) return null;
                ref = "tags/" + head.getName();
            }
            return new BitbucketSCMFileSystem(apiClient, (String)ref, rev);
        }
    }
}

