/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketSCMSourcePushHookReceiver
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSourcePushHookReceiver.class.getName());
    private static final String PATH = "bitbucket-scmsource-hook";
    public static final String FULL_PATH = "bitbucket-scmsource-hook/notify";

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/bitbucket-scmsource-hook/notify")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public String getUrlName() {
        return PATH;
    }

    public HttpResponse doNotify(StaplerRequest2 req) throws IOException {
        String origin = SCMEvent.originOf((HttpServletRequest)req);
        String body = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String eventKey = req.getHeader("X-Event-Key");
        if (eventKey == null) {
            return HttpResponses.error((int)400, (String)"X-Event-Key HTTP header not found");
        }
        HookEventType type = HookEventType.fromString(eventKey);
        if (type == null) {
            LOGGER.info("Received unknown Bitbucket hook: " + eventKey + ". Skipping.");
            return HttpResponses.error((int)400, (String)("X-Event-Key HTTP header invalid: " + eventKey));
        }
        String bitbucketKey = req.getHeader("X-Bitbucket-Type");
        String serverUrl = req.getParameter("server_url");
        BitbucketType instanceType = null;
        if (bitbucketKey != null) {
            instanceType = BitbucketType.fromString(bitbucketKey);
        }
        if (instanceType == null && serverUrl != null) {
            LOGGER.log(Level.FINE, "server_url request parameter found. Bitbucket Native Server webhook incoming.");
            instanceType = BitbucketType.SERVER;
        } else {
            LOGGER.log(Level.FINE, "X-Bitbucket-Type header / server_url request parameter not found. Bitbucket Cloud webhook incoming.");
        }
        try {
            type.getProcessor().process(type, body, instanceType, origin, serverUrl);
        }
        catch (AbstractMethodError e) {
            type.getProcessor().process(body, instanceType);
        }
        return HttpResponses.ok();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

