/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.NativeServerHeadEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerAPIClient;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerChange;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerMirrorRepoSynchronizedEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerRefsChangedEvent;
import com.google.common.base.Ascii;
import com.google.common.collect.HashMultimap;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;

public class NativeServerPushHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(NativeServerPushHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
    }

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin, String serverUrl) {
        String mirrorId;
        List<NativeServerChange> changes;
        BitbucketServerRepository repository;
        block11: {
            if (payload == null) {
                return;
            }
            try {
                Object event;
                if (hookEvent == HookEventType.SERVER_REFS_CHANGED) {
                    event = JsonParser.toJava(payload, NativeServerRefsChangedEvent.class);
                    repository = ((NativeServerRefsChangedEvent)event).getRepository();
                    changes = ((NativeServerRefsChangedEvent)event).getChanges();
                    mirrorId = null;
                    break block11;
                }
                if (hookEvent == HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED) {
                    event = JsonParser.toJava(payload, NativeServerMirrorRepoSynchronizedEvent.class);
                    repository = ((NativeServerMirrorRepoSynchronizedEvent)event).getRepository();
                    changes = ((NativeServerMirrorRepoSynchronizedEvent)event).getChanges();
                    mirrorId = ((NativeServerMirrorRepoSynchronizedEvent)event).getMirrorServer().getId();
                    break block11;
                }
                throw new UnsupportedOperationException("Unsupported hook event " + hookEvent);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
                return;
            }
        }
        if (changes.isEmpty()) {
            String owner = repository.getOwnerName();
            String repositoryName = repository.getRepositoryName();
            LOGGER.log(Level.INFO, "Received hook from Bitbucket. Processing push event on {0}/{1}", new Object[]{owner, repositoryName});
            this.scmSourceReIndex(owner, repositoryName);
            return;
        }
        HashMultimap events = HashMultimap.create();
        for (NativeServerChange change : changes) {
            String type = change.getType();
            if ("UPDATE".equals(type)) {
                events.put((Object)SCMEvent.Type.UPDATED, (Object)change);
                continue;
            }
            if ("DELETE".equals(type)) {
                events.put((Object)SCMEvent.Type.REMOVED, (Object)change);
                continue;
            }
            if ("ADD".equals(type)) {
                events.put((Object)SCMEvent.Type.CREATED, (Object)change);
                continue;
            }
            LOGGER.log(Level.INFO, "Unknown change event type of {0} received from Bitbucket Server", type);
        }
        for (SCMEvent.Type type : events.keySet()) {
            HeadEvent headEvent = new HeadEvent(serverUrl, type, events.get((Object)type), origin, repository, mirrorId);
            SCMHeadEvent.fireLater((SCMHeadEvent)headEvent, (long)BitbucketSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static final class HeadEvent
    extends NativeServerHeadEvent<Collection<NativeServerChange>>
    implements HasPullRequests {
        private final BitbucketServerRepository repository;
        private final Map<CacheKey, Map<String, BitbucketServerPullRequest>> cachedPullRequests = new HashMap<CacheKey, Map<String, BitbucketServerPullRequest>>();
        private final String mirrorId;

        HeadEvent(String serverUrl, SCMEvent.Type type, Collection<NativeServerChange> payload, String origin, BitbucketServerRepository repository, String mirrorId) {
            super(serverUrl, type, payload, origin);
            this.repository = repository;
            this.mirrorId = mirrorId;
        }

        @Override
        protected BitbucketServerRepository getRepository() {
            return this.repository;
        }

        @Override
        protected Map<SCMHead, SCMRevision> heads(BitbucketSCMSource source) {
            HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
            if (!this.eventMatchesRepo(source)) {
                return result;
            }
            this.addBranchesAndTags(source, result);
            try {
                this.addPullRequests(source, result);
            }
            catch (InterruptedException interrupted) {
                LOGGER.log(Level.INFO, "Interrupted while fetching Pull Requests from Bitbucket, results may be incomplete.");
            }
            return result;
        }

        private void addBranchesAndTags(BitbucketSCMSource src, Map<SCMHead, SCMRevision> result) {
            for (NativeServerChange change : (Collection)this.getPayload()) {
                AbstractGitSCMSource.SCMRevisionImpl revision;
                Object head;
                String refType = change.getRef().getType();
                if ("BRANCH".equals(refType)) {
                    head = new BranchSCMHead(change.getRef().getDisplayId());
                    revision = this.getType() == SCMEvent.Type.REMOVED ? null : new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, change.getToHash());
                    result.put((SCMHead)head, (SCMRevision)revision);
                    continue;
                }
                if ("TAG".equals(refType)) {
                    head = new BitbucketTagSCMHead(change.getRef().getDisplayId(), 0L);
                    revision = this.getType() == SCMEvent.Type.REMOVED ? null : new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, change.getToHash());
                    result.put((SCMHead)head, (SCMRevision)revision);
                    continue;
                }
                LOGGER.log(Level.INFO, "Received event for unknown ref type {0} of ref {1}", new Object[]{change.getRef().getType(), change.getRef().getDisplayId()});
            }
        }

        private void addPullRequests(BitbucketSCMSource src, Map<SCMHead, SCMRevision> result) throws InterruptedException {
            if (this.getType() != SCMEvent.Type.UPDATED) {
                return;
            }
            BitbucketSCMSourceContext ctx = this.contextOf(src);
            if (!ctx.wantPRs()) {
                return;
            }
            String sourceOwnerName = src.getRepoOwner();
            String sourceRepoName = src.getRepository();
            BitbucketServerRepository eventRepo = this.repository;
            SCMHeadOrigin headOrigin = src.originOf(eventRepo.getOwnerName(), eventRepo.getRepositoryName());
            Set<ChangeRequestCheckoutStrategy> strategies = headOrigin == SCMHeadOrigin.DEFAULT ? ctx.originPRStrategies() : ctx.forkPRStrategies();
            for (NativeServerChange change : (Collection)this.getPayload()) {
                if (!"BRANCH".equals(change.getRef().getType())) {
                    LOGGER.log(Level.INFO, "Received event for unknown ref type {0} of ref {1}", new Object[]{change.getRef().getType(), change.getRef().getDisplayId()});
                    continue;
                }
                for (BitbucketServerPullRequest pullRequest : this.getPullRequests(src, change).values()) {
                    BitbucketServerRepository targetRepo = pullRequest.getDestination().getRepository();
                    if (!sourceOwnerName.equalsIgnoreCase(targetRepo.getOwnerName()) || !sourceRepoName.equalsIgnoreCase(targetRepo.getRepositoryName())) continue;
                    for (ChangeRequestCheckoutStrategy strategy : strategies) {
                        if (strategy != ChangeRequestCheckoutStrategy.MERGE && !change.getRefId().equals(pullRequest.getSource().getRefId())) continue;
                        String originalBranchName = pullRequest.getSource().getBranch().getName();
                        String branchName = String.format("PR-%s%s", pullRequest.getId(), strategies.size() > 1 ? "-" + Ascii.toLowerCase((String)strategy.name()) : "");
                        BitbucketServerRepository pullRequestRepository = pullRequest.getSource().getRepository();
                        PullRequestSCMHead head = new PullRequestSCMHead(branchName, pullRequestRepository.getOwnerName(), pullRequestRepository.getRepositoryName(), originalBranchName, pullRequest, headOrigin, strategy);
                        String targetHash = pullRequest.getDestination().getCommit().getHash();
                        String pullHash = pullRequest.getSource().getCommit().getHash();
                        result.put(head, (SCMRevision)new PullRequestSCMRevision(head, new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), targetHash), new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, pullHash)));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, BitbucketServerPullRequest> getPullRequests(BitbucketSCMSource src, NativeServerChange change) throws InterruptedException {
            Map<String, BitbucketServerPullRequest> pullRequests;
            CacheKey cacheKey = new CacheKey(src, change);
            Map<CacheKey, Map<String, BitbucketServerPullRequest>> map = this.cachedPullRequests;
            synchronized (map) {
                pullRequests = this.cachedPullRequests.get(cacheKey);
                if (pullRequests == null) {
                    pullRequests = this.loadPullRequests(src, change);
                    this.cachedPullRequests.put(cacheKey, pullRequests);
                }
            }
            return pullRequests;
        }

        private Map<String, BitbucketServerPullRequest> loadPullRequests(BitbucketSCMSource src, NativeServerChange change) throws InterruptedException {
            BitbucketServerRepository eventRepo = this.repository;
            BitbucketServerAPIClient api = (BitbucketServerAPIClient)src.buildBitbucketClient(eventRepo.getOwnerName(), eventRepo.getRepositoryName());
            HashMap<String, BitbucketServerPullRequest> pullRequests = new HashMap<String, BitbucketServerPullRequest>();
            try {
                try {
                    for (BitbucketServerPullRequest pullRequest : api.getOutgoingOpenPullRequests(change.getRefId())) {
                        pullRequests.put(pullRequest.getId(), pullRequest);
                    }
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve outgoing Pull Requests from Bitbucket", e);
                }
                try {
                    for (BitbucketServerPullRequest pullRequest : api.getIncomingOpenPullRequests(change.getRefId())) {
                        pullRequests.put(pullRequest.getId(), pullRequest);
                    }
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve incoming Pull Requests from Bitbucket", e);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.INFO, "No such Repository on Bitbucket: {0}", e.getMessage());
            }
            return pullRequests;
        }

        public Collection<BitbucketPullRequest> getPullRequests(BitbucketSCMSource src) throws InterruptedException {
            ArrayList<BitbucketPullRequest> prs = new ArrayList<BitbucketPullRequest>();
            for (NativeServerChange change : (Collection)this.getPayload()) {
                Map<String, BitbucketServerPullRequest> prsForChange = this.getPullRequests(src, change);
                prs.addAll(prsForChange.values());
            }
            return prs;
        }

        @Override
        protected boolean eventMatchesRepo(BitbucketSCMSource source) {
            return Objects.equals(source.getMirrorId(), this.mirrorId) && super.eventMatchesRepo(source);
        }
    }

    private static final class CacheKey {
        @NonNull
        private final String refId;
        @CheckForNull
        private final String credentialsId;

        CacheKey(BitbucketSCMSource src, NativeServerChange change) {
            this.refId = Objects.requireNonNull(change.getRefId());
            this.credentialsId = src.getCredentialsId();
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.refId);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.credentialsId, other.credentialsId) && this.refId.equals(other.refId);
            }
            return false;
        }
    }
}

