/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;

@Restricted(value={ProtectedExternally.class})
public abstract class AbstractBitbucketApi {
    protected static final int API_RATE_LIMIT_STATUS_CODE = 429;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected HttpClientContext context;

    protected String truncateMiddle(@CheckForNull String value, int maxLength) {
        int length = StringUtils.length((String)value);
        if (length > maxLength) {
            int halfLength = (maxLength - 3) / 2;
            return StringUtils.left((String)value, (int)halfLength) + "..." + StringUtils.substring((String)value, (int)(-halfLength));
        }
        return value;
    }

    protected BitbucketRequestException buildResponseException(CloseableHttpResponse response, String errorMessage) {
        String headers = StringUtils.join((Object[])response.getAllHeaders(), (String)"\n");
        String message = String.format("HTTP request error.%nStatus: %s%nResponse: %s%n%s", response.getStatusLine(), errorMessage, headers);
        return new BitbucketRequestException(response.getStatusLine().getStatusCode(), message);
    }

    protected String getResponseContent(CloseableHttpResponse response) throws IOException {
        String content;
        long len = response.getEntity().getContentLength();
        if (len < 0L) {
            len = this.getLenghtFromHeader(response);
        }
        if (len == 0L) {
            content = "";
        } else {
            try (InputStream is = response.getEntity().getContent();){
                content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
        }
        return content;
    }

    private long getLenghtFromHeader(CloseableHttpResponse response) {
        long len = -1L;
        Header[] headers = response.getHeaders("Content-Length");
        if (headers != null && headers.length > 0) {
            len = -1L;
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    len = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException var5) {
                    continue;
                }
            }
        }
        return len;
    }

    protected void setClientProxyParams(String host, HttpClientBuilder builder) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfig = jenkins != null ? jenkins.proxy : null;
        Proxy proxy = proxyConfig != null ? proxyConfig.createProxy(host) : Proxy.NO_PROXY;
        if (proxy != Proxy.NO_PROXY && proxy.type() != Proxy.Type.DIRECT) {
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            this.logger.fine("Jenkins proxy: " + proxy.address());
            HttpHost proxyHttpHost = new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort());
            builder.setProxy(proxyHttpHost);
            String username = proxyConfig.getUserName();
            String password = Secret.toString((Secret)proxyConfig.getSecretPassword());
            if (StringUtils.isNotBlank((String)username)) {
                CredentialsProvider credentialsProvider;
                this.logger.fine("Using proxy authentication (user=" + username + ")");
                if (this.context == null) {
                    this.context = HttpClientContext.create();
                }
                if ((credentialsProvider = this.context.getCredentialsProvider()) == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    this.context.setCredentialsProvider(credentialsProvider);
                }
                credentialsProvider.setCredentials(new AuthScope(proxyHttpHost), (Credentials)new UsernamePasswordCredentials(username, password));
                AuthCache authCache = this.context.getAuthCache();
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    this.context.setAuthCache(authCache);
                }
                authCache.put(proxyHttpHost, (AuthScheme)new BasicScheme());
            }
        }
    }
}

