/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import org.apache.http.HttpRequest;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitbucketAccessTokenAuthenticator
implements BitbucketAuthenticator {
    private final String credentialsId;
    private final Secret token;

    public BitbucketAccessTokenAuthenticator(StringCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.token = credentials.getSecret();
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.setHeader("Authorization", "Bearer " + Secret.toString((Secret)this.token));
    }

    @Override
    public StandardUsernameCredentials getCredentialsForSCM() {
        try {
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, this.getId(), null, "x-token-auth", Secret.toString((Secret)this.token));
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

