/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketOAuth;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import jenkins.util.SetContextClassLoader;
import org.apache.http.HttpRequest;

public class BitbucketOAuthAuthenticator
implements BitbucketAuthenticator {
    private final String credentialsId;
    private final String username;
    private final Secret password;
    private OAuth2AccessToken token;

    public BitbucketOAuthAuthenticator(StandardUsernamePasswordCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    private OAuth2AccessToken getToken() {
        if (this.token == null) {
            try (SetContextClassLoader cl = new SetContextClassLoader(this.getClass());
                 OAuth20Service service = new ServiceBuilder(this.username).apiSecret(Secret.toString((Secret)this.password)).httpClientConfig((HttpClientConfig)JDKHttpClientConfig.defaultConfig()).build((DefaultApi20)BitbucketOAuth.instance());){
                this.token = service.getAccessTokenClientCredentialsGrant();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return this.token;
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.addHeader("Authorization", "Bearer " + this.getToken().getAccessToken());
    }

    @Override
    public StandardUsernameCredentials getCredentialsForSCM() {
        try {
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, this.getId(), null, "x-token-auth", this.getToken().getAccessToken());
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

