/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitbucketOAuthCredentialMatcher
implements CredentialsMatcher {
    private static final long serialVersionUID = 6458784517693211197L;
    private static final Logger logger = Logger.getLogger(BitbucketOAuthCredentialMatcher.class.getName());
    private static final int CLIENT_KEY_LENGTH = 18;
    private static final int CLIENT_SECRET_LENGTH = 32;

    public boolean matches(Credentials item) {
        if (!(item instanceof UsernamePasswordCredentials)) {
            return false;
        }
        if (item.getClass().getName().equals("com.cloudbees.jenkins.plugins.amazonecr.AmazonECSRegistryCredential")) {
            return false;
        }
        try {
            UsernamePasswordCredentials usernamePasswordCredential = (UsernamePasswordCredentials)item;
            String username = usernamePasswordCredential.getUsername();
            boolean isEMail = username.contains(".") && username.contains("@");
            boolean validSecretLength = usernamePasswordCredential.getPassword().getPlainText().length() == 32;
            boolean validKeyLength = username.length() == 18;
            return !isEMail && validKeyLength && validSecretLength;
        }
        catch (RuntimeException e) {
            logger.log(Level.FINE, "Caught exception validating credential", e);
            return false;
        }
    }
}

