/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.core.Authentication;

public class BitbucketCredentials {
    private BitbucketCredentials() {
        throw new IllegalAccessError("Utility class");
    }

    @CheckForNull
    public static <T extends StandardCredentials> T lookupCredentials(@CheckForNull String serverUrl, @CheckForNull SCMSourceOwner context, @CheckForNull String id, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((String)id) && context != null) {
            Authentication authentication;
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            Authentication authentication2 = authentication;
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(type, (Item)context, (Authentication)authentication2, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(type)})})));
        }
        return null;
    }

    public static ListBoxModel fillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
        Authentication authentication;
        Jenkins contextToCheck;
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        Object object = contextToCheck = context == null ? Jenkins.get() : context;
        if (!contextToCheck.hasPermission(CredentialsProvider.VIEW)) {
            return result;
        }
        if (context instanceof Queue.Task) {
            Queue.Task task = (Queue.Task)context;
            authentication = task.getDefaultAuthentication2();
        } else {
            authentication = ACL.SYSTEM2;
        }
        Authentication authentication2 = authentication;
        result.includeMatchingAs(authentication2, (Item)context, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl)));
        return result;
    }

    public static FormValidation checkCredentialsId(@AncestorInPath @CheckForNull SCMSourceOwner context, @QueryParameter String value, @QueryParameter String serverUrl) {
        if (!value.isEmpty()) {
            Authentication authentication;
            Jenkins contextToCheck = context == null ? Jenkins.get() : context;
            contextToCheck.checkPermission(CredentialsProvider.VIEW);
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                v0 = task.getDefaultAuthentication2();
            } else {
                v0 = authentication = ACL.SYSTEM2;
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardCertificateCredentials.class, (Item)context, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl))})) != null) {
                return FormValidation.warning((String)"A certificate was selected. You will likely need to configure Checkout over SSH.");
            }
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Credentials are required for build notifications");
    }
}

